/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.parameterization;

import edu.uci.ics.jung.algorithms.shortestpath.PrimMinimumSpanningTree;
import edu.uci.ics.jung.algorithms.transformation.FoldingTransformerFixed;
import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.SetHypergraph;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drugis.mtc.graph.GraphUtil;
import org.drugis.mtc.model.Network;
import org.drugis.mtc.model.Study;
import org.drugis.mtc.model.Treatment;
import org.drugis.mtc.parameterization.BasicParameter;
import org.drugis.mtc.parameterization.ConsistencyParameterization;
import org.drugis.mtc.parameterization.NetworkModel;
import org.drugis.mtc.parameterization.NetworkParameter;
import org.drugis.mtc.parameterization.SplitParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeSplitParameterization
extends ConsistencyParameterization {
    private final BasicParameter d_splitNode;

    public static NodeSplitParameterization create(Network network, BasicParameter split) {
        Hypergraph<Treatment, Study> sGraph = NetworkModel.createStudyGraph(network);
        UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> cGraph = NetworkModel.createComparisonGraph(sGraph);
        Tree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> tree = NodeSplitParameterization.findSpanningTree(cGraph, split);
        Map<Study, Treatment> baselines = NodeSplitParameterization.findStudyBaselines(sGraph, tree, split);
        NodeSplitParameterization pmtz = new NodeSplitParameterization(network, split, tree, baselines);
        return pmtz;
    }

    public static List<BasicParameter> getSplittableNodes(Network network) {
        Hypergraph<Treatment, Study> studyGraph = NetworkModel.createStudyGraph(network);
        UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> cGraph = NetworkModel.createComparisonGraph(studyGraph);
        return NodeSplitParameterization.getSplittableNodes(studyGraph, cGraph);
    }

    public static List<BasicParameter> getSplittableNodes(Hypergraph<Treatment, Study> studyGraph, UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> cGraph) {
        PrimMinimumSpanningTree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> treeBuilder = new PrimMinimumSpanningTree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>>(DelegateTree.getFactory());
        Tree tree = (Tree)treeBuilder.transform((Graph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>>)cGraph);
        HashSet nonTreeEdges = new HashSet(cGraph.getEdges());
        nonTreeEdges.removeAll(tree.getEdges());
        HashSet<BasicParameter> inCycle = new HashSet<BasicParameter>();
        for (FoldingTransformerFixed.FoldedEdge e : nonTreeEdges) {
            List<Treatment> cycle = GraphUtil.findPath(tree, (Treatment)e.getVertices().getFirst(), (Treatment)e.getVertices().getSecond());
            cycle.add((Treatment)e.getVertices().getFirst());
            int i = 1;
            while (i < cycle.size()) {
                Pair treatments = ((FoldingTransformerFixed.FoldedEdge)cGraph.findEdge(cycle.get(i - 1), cycle.get(i))).getVertices();
                inCycle.add(new BasicParameter((Treatment)treatments.getFirst(), (Treatment)treatments.getSecond()));
                ++i;
            }
        }
        ArrayList<BasicParameter> paramList = new ArrayList<BasicParameter>();
        for (BasicParameter param : inCycle) {
            if (!NodeSplitParameterization.isSplittable(studyGraph, new Pair<Treatment>(param.getBaseline(), param.getSubject()))) continue;
            paramList.add(param);
        }
        Collections.sort(paramList);
        return paramList;
    }

    public static boolean isSplittable(Hypergraph<Treatment, Study> studyGraph, Pair<Treatment> split) {
        SetHypergraph<Treatment, Study> reduced = new SetHypergraph<Treatment, Study>();
        for (Treatment t : studyGraph.getVertices()) {
            reduced.addVertex(t);
        }
        for (Study s : studyGraph.getEdges()) {
            Collection<Treatment> incidentVertices = studyGraph.getIncidentVertices(s);
            if (incidentVertices.containsAll(split)) {
                if (incidentVertices.size() <= 3) continue;
                HashSet<Treatment> reducedVertices = new HashSet<Treatment>(studyGraph.getVertices());
                reducedVertices.removeAll(split);
                reduced.addEdge(s, (Collection<Treatment>)reducedVertices);
                continue;
            }
            reduced.addEdge(s, incidentVertices);
        }
        return GraphUtil.areVerticesWeaklyConnected(reduced, split.getFirst(), split.getSecond());
    }

    public static Tree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> findSpanningTree(UndirectedGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> cGraph, BasicParameter split) {
        UndirectedSparseGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> graph = new UndirectedSparseGraph<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>>();
        GraphUtil.copyGraph(cGraph, graph);
        graph.removeEdge((FoldingTransformerFixed.FoldedEdge)cGraph.findEdge(split.getBaseline(), split.getSubject()));
        return ConsistencyParameterization.findSpanningTree(graph);
    }

    public static Map<Study, Treatment> findStudyBaselines(Hypergraph<Treatment, Study> studyGraph, Tree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> tree, BasicParameter split) {
        Pair<Treatment> splitVertices = new Pair<Treatment>(split.getBaseline(), split.getSubject());
        HashMap<Study, Treatment> map = new HashMap<Study, Treatment>();
        for (Study s : studyGraph.getEdges()) {
            Collection<Treatment> incidentVertices = studyGraph.getIncidentVertices(s);
            if (incidentVertices.size() > 2 && incidentVertices.containsAll(splitVertices)) {
                incidentVertices = new HashSet<Treatment>(incidentVertices);
                incidentVertices.removeAll(splitVertices);
            }
            map.put(s, NodeSplitParameterization.findMaxDegreeVertex(tree, incidentVertices));
        }
        return map;
    }

    public NodeSplitParameterization(Network network, BasicParameter splitNode, Tree<Treatment, FoldingTransformerFixed.FoldedEdge<Treatment, Study>> tree, Map<Study, Treatment> baselines) {
        super(network, tree, baselines);
        this.d_splitNode = splitNode;
    }

    @Override
    public List<NetworkParameter> getParameters() {
        List<NetworkParameter> parameters = super.getParameters();
        parameters.add(this.getDirectParameter());
        return parameters;
    }

    @Override
    public Map<NetworkParameter, Integer> parameterize(Treatment ta, Treatment tb) {
        if (this.d_splitNode.getBaseline().equals(ta) && this.d_splitNode.getSubject().equals(tb)) {
            HashMap<NetworkParameter, Integer> map = new HashMap<NetworkParameter, Integer>();
            map.put(this.getDirectParameter(), 1);
            return map;
        }
        if (this.d_splitNode.getBaseline().equals(tb) && this.d_splitNode.getSubject().equals(ta)) {
            HashMap<NetworkParameter, Integer> map = new HashMap<NetworkParameter, Integer>();
            map.put(this.getDirectParameter(), -1);
            return map;
        }
        return super.parameterize(ta, tb);
    }

    public SplitParameter getDirectParameter() {
        return new SplitParameter(this.d_splitNode.getBaseline(), this.d_splitNode.getSubject(), true);
    }

    public SplitParameter getIndirectParameter() {
        return new SplitParameter(this.d_splitNode.getBaseline(), this.d_splitNode.getSubject(), false);
    }

    public Map<NetworkParameter, Integer> parameterizeIndirect() {
        return super.parameterize(this.d_splitNode.getBaseline(), this.d_splitNode.getSubject());
    }

    @Override
    public List<List<Pair<Treatment>>> parameterizeStudy(Study s) {
        Pair<Treatment> split = new Pair<Treatment>(this.d_splitNode.getBaseline(), this.d_splitNode.getSubject());
        if (s.getTreatments().size() == 2 || !s.getTreatments().containsAll(split)) {
            return super.parameterizeStudy(s);
        }
        List<Pair<Treatment>> params1 = super.parameterizeStudy(s).get(0);
        params1.remove(new Pair<Treatment>(this.getStudyBaseline(s), this.d_splitNode.getSubject()));
        ArrayList<Pair<Treatment>> params2 = new ArrayList<Pair<Treatment>>();
        params2.add(split);
        ArrayList<List<Pair<Treatment>>> params = new ArrayList<List<Pair<Treatment>>>();
        params.add(params1);
        params.add(params2);
        return params;
    }

    public BasicParameter getSplitNode() {
        return this.d_splitNode;
    }
}

