% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_correction_function.R
\name{errorCorrection}
\alias{errorCorrection}
\title{Error Correction}
\usage{
errorCorrection(BC_dat, maxHD, save_it = FALSE)
}
\arguments{
\item{BC_dat}{a BCdat object, containing the necessary sequences.}

\item{maxHD}{an integer value representing the maximal hamming distance for which it is allowed to
cluster two sequences together.}

\item{save_it}{a logical value. If TRUE the data will be saved as csv-file.}
}
\description{
Corrects a list of equally long (barcode) sequences. Based on calculated hamming distances
as a measure of similarity, highly similar sequences are clustered together and the cluster label will
be the respective sequence with the highest read count.
}
\examples{
errorCorrection(BC_dat, maxHD = 8, save_it = FALSE)
}
