% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plotClusterTree}
\alias{plotClusterTree}
\title{Plotting a Cluster Tree}
\usage{
plotClusterTree(BC_dat, tree_est = "NJ", type = "unrooted",
  tipLabel = FALSE, m = "hamming")
}
\arguments{
\item{BC_dat}{a BCdat object.}

\item{tree_est}{a character string, indicating the particular cluster algorithm, possible algorithms are "Neighbor-Joining" ("NJ") and "Unweighted Pair Group Method" ("UPGMA").}

\item{type}{a character string, the graph layout style ("unrooted", "phylogram", "cladogram", "fan", "radial").}

\item{tipLabel}{a logical value, indicating the use of labeled tree leaves.}

\item{m}{a character string, Method for distance calculation, default value is Hamming distance. Possible values
are "osa", "lv", "dl", "hamming", "lcs", "qgram", "cosine", "jaccard", "jw", "soundex" (see stringdist function
of the stringdist-package for more information).}
}
\description{
Generates a tree plot based on a herachical clustering of the complete distance matrix.
}
\examples{
data(BC_dat)
plotClusterTree(BC_dat, tree_est = "UPGMA", type = "unrooted", tipLabel = FALSE)
}
