% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{genderName}
\alias{genderName}
\title{Gender of Name API}
\usage{
genderName(first_names)
}
\arguments{
\item{first_names}{The name that you want to know the gender of. Please only use the first name
without any spaces.}
}
\value{
A dataframe with one row for every name and 3 columns. The columns tell the
inputted name, the gender, and the probability that the gender is accurate.
}
\description{
Gender of Name API
}
\examples{
genderName("Tom")
genderName("Mary")
genderName("Sasha")

# example of no gender found for the name
genderName("")

genderName(c("Tom", "Mary", "Sasha"))

# It can take a list an input, even a list with bad values (such as "")
example <- c("Tom", "Mary", "",  "Sasha")
genderName(example)

example <- data.frame(name = c("Tom", "Mary", "Sasha"))
genderName(example$name)

}

