% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genderizeAPI.R
\name{genderizeAPI}
\alias{genderizeAPI}
\title{Getting data from genderize.io  API}
\usage{
genderizeAPI(x, country = NULL, language = NULL, apikey = NULL,
  ssl.verifypeer = TRUE)
}
\arguments{
\item{x}{A vector of terms to check in genderize.io database.}

\item{country}{A character string with a country code for localized search
of names. Country codes follow the ISO_3166-1 alpha-2 standard
\url{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}.}

\item{language}{A character string with a language code for localized search
of names. Language codes follow the ISO_639-1 standard: 
\url{https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes}}

\item{apikey}{A character string with the API key obtained via 
\url{https://store.genderize.io}. A default is NULL, which uses the free API 
 plan. If you reached the limit of the API you can start from the last 
 checked term next time.}

\item{ssl.verifypeer}{If TRUE (default) it checks the SSL Certificate.}
}
\value{
A list of four elements: \code{response} is a data frame with names, 
genders, probabilities and counts or \code{NULL} if no terms are found 
in the genderize.io database; \code{limitLeft} is showing how many API queries 
are still possible within the current \code{limit} which will be renewed 
in \code{limitReset} seconds.
}
\description{
The \code{genderizeAPI} function connects to genderize.io API and checks if 
a term (one or more) is in the genderize.io database and returns 
predicted gender probability and count of the records with this 
term in the database.
}
\examples{
\dontrun{

terms = c("loremipsum")
genderizeAPI(terms)$response
# Null data.table (0 rows and 0 cols)

terms = c("jan", "maria", "norbert", "winston", "loremipsum")
genderizeAPI(terms)
 
# example of the function output 
$response
      name gender probability count
      1:     jan   male        0.60  1692
      2:   maria female        0.99  8467
      3: norbert   male        1.00    77
      4: winston   male        0.98   128

$limitLeft
[1] 967

$limit
[1] 1000

$limitReset
[1] 83234 

}

}
