% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hapVisualization.R
\name{plotHapTable}
\alias{plotHapTable}
\title{plotHapTable}
\usage{
plotHapTable(hapSummary,
             hapPrefix = "H",
             title = "",
             geneName = geneName,
             INFO_tag = INFO_tag,
             tag_split = tag_split,
             tag_field = tag_field,
             tag_name = tag_name,
             displayIndelSize = 0, angle = c(0,45,90),
             replaceMultiAllele = TRUE,
             ALLELE.color = "grey90")
}
\arguments{
\item{hapSummary}{object of hapSummary class}

\item{hapPrefix}{prefix of haplotype names. Default as "H"}

\item{title}{the main title of the final figure}

\item{geneName}{character, will be used for filter INFO filed of ANN}

\item{INFO_tag}{The annotations in the INFO field are represented as tag-value
pairs, where the tag and value are separated by an equal sign, ie "=", and
pairs are separated by colons, ie ";".
For more information please see details.}

\item{tag_split}{usually, the value of tag-value contains one information.
However, if a tag contains more than one fields, eg "ANN", then \code{tag_split} is
needed. When \code{INFO_tag} was set as "ANN" or "SNPEFF", \code{tag_split} will be set
as "|" by default, see details.}

\item{tag_field}{integer, if a tag-value contains more than one fields,
user need to specified which field should be display. If \code{tag_field} set as
0, the whole contents will be displayed. Default as 0.}

\item{tag_name}{tag name is displayed in Hap figure. If \code{tag_name} is
missing, will take the value of \code{INFO_tag}.}

\item{displayIndelSize}{display indels with max size of \code{displayIndelSize},
If set as 0, all indels will convert into "i*" of which "i" represents "indel".}

\item{angle}{the angle of coordinates, should be one of 0, 45 and 90}

\item{replaceMultiAllele}{whether to replace MultiAllele with "T*",
default as \code{TRUE}.}

\item{ALLELE.color}{the color of ALLELE row, default as "grey90"}
}
\value{
ggplot2 object
}
\description{
display hap result as a table-like figure
}
\details{
In \strong{VCF} files, the INFO field are represented as tag-value
pairs, where the tag and value are separated by an equal sign, ie "=", and
pairs are separated by colons, ie ";".

If hapSummarys were generated from sequences, INFO row is null.
If hapSummarys were generated from VCF, INFO was take from the INFO column
in the source VCF file.
Some tag-values may contains more than one value separated by
"|", eg.: "ANN" or "snpEFF" added by 'snpeff' or other software. For those
fields we need specified value of \code{tag_field = "ANN"} and \code{tag_split = "[\\|]"},
it's suggest specified the value of \code{tag_name} for display in figure.

'snpeff', a toolbox for genetic variant annotation and functional effect
prediction, will add annotations to INFO filed in VCF file under a tag
named as "ANN". The annotations contains several fields separated by "|".
eg.:
\enumerate{
\item Allele
\item Annotation
\item Annotation_Impact
\item Gene_Name
\item Gene_ID
\item Feature_Type
\item Feature_ID
\item Transcript_BioType
\item Rank
\item HGVS.c
\item HGVS.p
\item cDNA.pos/cDNA.length
... ...
}

However, the INFO in hapResults may missing annotations that we need.
In this case, we can custom INFOs in hapSummarys with \code{addINFO()}.
Once the needed annotations were included in hap results, we can display
them with \code{plotHapTable()} by specify the value of \code{INFO_tag}.
}
\examples{
data("geneHapR_test")
plotHapTable(hapResult)
}
\seealso{
\code{\link[geneHapR:addINFO]{addINFO()}}
}
