% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hap2table.R
\name{table2hap}
\alias{table2hap}
\title{table2hap}
\usage{
table2hap(x, hapPrefix = "H", pad = 3, hetero_remove = TRUE, na_drop = TRUE)
}
\arguments{
\item{x}{a data.frame contains variants information.
The first file column are fix as Chrome name, position, reference nuclieotide,
alter nuclieotide and INFO. Accession genotype should be in followed columns.
"-" will be treated as Indel. "." and "N" will be treated as missing data.
Heterozygotes should be "A/T", "AAA/A"}

\item{hapPrefix}{prefix of haplotype names}

\item{pad}{The number length in haplotype names should be extend to.}

\item{hetero_remove}{whether remove accessions contains hyb-sites, Character not A T C G}

\item{na_drop}{whether drop accessions contains missing data ("N", "NA", ".")}
}
\value{
object of hapSummary class
}
\description{
convert variants stored in table format into hapResult
}
\examples{
\donttest{
   data("geneHapR_test")
   hapResult <- table2hap(gt.geno, hapPrefix = "H",
                          hetero_remove = TRUE,
                          na_drop = TRUE)
}
}
