% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adj_setATGas0.R
\name{SetATGas0}
\alias{SetATGas0}
\alias{gffSetATGas0}
\alias{hapSetATGas0}
\title{Set Position of ATG as Zero}
\usage{
gffSetATGas0(gff = gff, hap = hap,
             geneID = geneID,
             Chr = Chr, POS = POS)

hapSetATGas0(gff = gff, hap = hap,
             geneID = geneID,
             Chr = Chr, POS = POS)
}
\arguments{
\item{gff}{gene annotations}

\item{hap}{object of hapResult or hapSummary class}

\item{geneID}{geneID}

\item{Chr}{Chromsome name}

\item{POS}{vector consist with start and end position}
}
\value{
\code{gffSetATGas0}: filtered gff with position of ATG was as zero

\code{hapSetATGas0}: hap results with position of ATG was set as zero
}
\description{
Set position of ATG as zero in hap result and gff annotation.
The upstream was negative while the gene range and downstream was positive.
}
\details{
Filter hap result and gff annotation according to provided information.
And then set position of ATG as zero in hap result and gff annotation.
The upstream was negative while the gene range and downstream was positive.

\strong{Notice:} the position of "ATG" after modified was 0, 1 and 2 separately.
The site in hap result exceed the selected range will be \strong{dropped}.
}
\examples{
\donttest{
# load example dataset
data("geneHapR_test")


# set position of ATG as zero in gff
newgff <- gffSetATGas0(gff = gff, hap = hapResult,
                       geneID = "test1G0387",
                       Chr = "scaffold_1",
                       POS = c(4300, 7910))

}
data("geneHapR_test")

# set position of ATG as zero in hap results
newhapResult <- hapSetATGas0(gff = gff, hap = hapResult,
                             geneID = "test1G0387",
                             Chr = "scaffold_1",
                             POS = c(4300, 7910))
}
\seealso{
\code{\link[geneHapR:displayVarOnGeneModel]{displayVarOnGeneModel()}}
}
