% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneSNP.R
\name{geneSNP}
\alias{geneSNP}
\title{Identifies Candidate Genes based on identified Single Nucleotide Ploymorphisms (SNPs) from Genome Wide Association Stuides (GWAS) Analysis}
\usage{
geneSNP(data_file, upstream = 1e+06, downstream = 1e+06, crop = "wheat")
}
\arguments{
\item{data_file}{The input data in .csv format. (sample_data_wheat or sample_data_rice for demo purpose)}

\item{upstream}{The search window upstream of the current position of the SNP. (default: 1000000)}

\item{downstream}{The search window downstream of the current position of the SNP. (default: 1000000)}

\item{crop}{Either "wheat" or "rice". (default: wheat)}
}
\value{
A data frame containing traits, SNP, gene_id, gene_size, and gene_type.
}
\description{
Identifies Candidate Genes based on identified Single Nucleotide Ploymorphisms (SNPs) from Genome Wide Association Stuides (GWAS) Analysis
}
\examples{
load(system.file("extdata", "precomputed_sample_results.rda", package = "geneNR"))
message(sample_results)
\donttest{
result <- geneSNP("sample_data_wheat", 10000, 10000, crop = "wheat")
result <- geneSNP("sample_data_rice", 10000, 10000, crop = "rice")
}
}
