% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/somePairs.R
\name{somePairs}
\alias{somePairs}
\title{Function reporting kernel causality results as a 7-column matrix.}
\usage{
somePairs(mtx, dig = 6, verbo = FALSE, typ = 1, rnam = FALSE)
}
\arguments{
\item{mtx}{{the data matrix in the first column is paired with all others.}}

\item{dig}{{=6 (default) number of digits for reporting.}}

\item{verbo}{{=FALSE (default). Make it TRUE for printing steps.}}

\item{typ}{{must be 1 (default), 2 or 3 for the three criteria.}}

\item{rnam}{{=FALSE (default). Make it TRUE if created rownames are wanted}}
}
\value{
A matrix containing causal identification results.  The last matrix
outVote reports summary results for all three criteria in column `sum'.
}
\description{
Three criteria are used:
}
\details{
(typ=1) reports ("Y", "X", "Cause",
"SD1apd", "SD2apd", "SD3apd", "SD4apd") nameing variables identifying "cause"
and measures of stochastic dominance using absolute values of kernel
regression gradients comparing regresson of X on Y with that of Y on X.

{(typ=2)} 
 reports ("Y", "X", "Cause", "SD1res", "SD2res", "SD3res", "SD4res")
 and measures of stochastic dominance using absolute values of kernel
 regression residuals comparing regresson of X on Y with that of Y on X.

{(typ=3)} 
reports ("Y", "X", "Cause", "r*x|y", "r*y|x", "r", "p-val")
containing generalized correlation coefficients r*, 'r' refers to.
Pearson correlation coefficient p-val is the p-value for 
testing the significance of Pearson 'r'
}
\note{
will not work without several functions and packages in memory
}
\examples{

\dontrun{
data(mtcars)
somePairs(mtcars)
}

}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\references{
H. D. Vinod "Generalized Correlation and Kernel Causality with
 Applications in Development Economics" in Communications in
 Statistics -Simulation and Computation, 2015,
 \url{http://dx.doi.org/10.1080/03610918.2015.1122048}
}
\seealso{
See Also \code{\link{some0Pairs}}.
}
\keyword{SD1,}
\keyword{SD2,}
\keyword{SD3,}
\keyword{SD4,}
\keyword{causal}
\keyword{correlations}
\keyword{criteria,}
\keyword{generalized}

