% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allPairs.R
\name{allPairs}
\alias{allPairs}
\title{Report causal identification for all pairs of variables in a matrix 
(deprecated function). It is better to choose a target variable and pair
it with all others, instead of considering all possible targets.}
\usage{
allPairs(mtx, dig = 6, verbo = FALSE, typ = 1, rnam = FALSE)
}
\arguments{
\item{mtx}{{Input matrix with variable names}}

\item{dig}{{Digits of accuracy in reporting (=6, default)}}

\item{verbo}{{Logical variable, set to 'TRUE' if printing is desired}}

\item{typ}{{Causal direction criterion number (typ=1 is default)
Criterion 1 (Cr1) compares kernel regression absolute values of gradients.
Criterion 2 (Cr2) compares kernel regression absolute values of residuals.
Criterion 3 (Cr3) compares kernel regression based r*(x|y) with r*(y|x)}.}

\item{rnam}{{Logical variable, default \code{rnam=FALSE} means the user does
not want the row names to be
(somewhat too cleverly) assigned by the function.}}
}
\value{
A 7-column matrix called 'outcause' with names of variables
 X and Y in the first two columns and the name of the 'causal' variable in 3rd col.
 Remaining four columns report numerical computations of SD1 to SD4, r*(x|y),
 r*(y|x).  Pearson r and p-values for its traditional significance testing.
}
\description{
This studies all possible (perhaps too many) causal directions in a matrix.
It is deprecated because it uses older criterion 1 by caling \code{abs_stdapd}
I recommend using \code{causeSummary} or its block version \code{cuseSummBlk}.
This uses \code{abs_stdres}, \code{comp_portfo2}, etc. and returns
a matrix with 7 columns having detailed output. Criterion 1 has been revised
as described in Vinod (2019) and is known to work better.
}
\note{
The cause reported in the third column
 is identified from the sign of the first SD1 only,
 ignoring SD2, SD3 and SD4  under both Cr1 and Cr2. It is
 a good idea to loop a call to this function with typ=1:3. One can print
 the resulting 'outcause' matrix with the 
 \code{xtable(outcause)} for the Latex output.
 A similar deprecated function included in this package,
  called \code{some0Pairs}, incorporates all SD1 to SD4 and all
 three criteria Cr1 rto Cr3 to report a `sum' of indexes representing the signed 
 number whose sign can more comprehensively help determine the causal direction(s).
 Since the Cr1 here is revised in later work, this is deprecated.
}
\examples{

data(mtcars)
options(np.messages=FALSE)
for(j in 1:3){
a1=allPairs(mtcars[,1:3], typ=j)
print(a1)}

}
\references{
Vinod, H. D.'Generalized Correlation and Kernel Causality with
 Applications in Development Economics' in Communications in
 Statistics -Simulation and Computation, 2015,
 \doi{10.1080/03610918.2015.1122048}

Vinod, H. D. 'New exogeneity tests and causal paths,'
 Chapter 2 in 'Handbook of Statistics: Conceptual Econometrics 
Using R', Vol.32, co-editors: H. D. Vinod and C.R. Rao. New York:
North Holland, Elsevier Science Publishers, 2019, pp. 33-64.
}
\seealso{
See Also  \code{somePairs}, \code{some0Pairs} \code{causeSummary}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\concept{absolute residual values}
\concept{amorphous partial derivative apd}
\concept{stochastic dominance}
