% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genesys.R
\name{.fetch_accessions_page}
\alias{.fetch_accessions_page}
\title{Fetch accession passport data (paginated)}
\usage{
.fetch_accessions_page(filters = list(), page = 0, size = 1000,
  selector = NULL)
}
\arguments{
\item{filters}{an R \code{structure} with Genesys filters}

\item{page}{the page index (0-based)}

\item{size}{number of records to load per page (page size)}

\item{selector}{NULL or a function to "select" variables of interest}
}
\value{
Paged data structure
}
\description{
Fetch accession passport data (paginated)
}
\examples{
\dontrun{
  # Retrieve accession data by country of origin
  accessions <- fetch_accessions(mcpd_filter(ORIGCTY = c("DEU", "SVN")))
}

}
\seealso{
\code{\link{mcpd_filter}}
}
