% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_unique_ngs.R
\name{select_unique_ngs}
\alias{select_unique_ngs}
\title{Selecting corresponding unique next generation sequencing reports}
\usage{
select_unique_ngs(
  data_cohort,
  oncotree_code = NULL,
  sample_type = NULL,
  min_max_time = NULL
)
}
\arguments{
\item{data_cohort}{output object of the create_analytic_cohort function.}

\item{oncotree_code}{character vector specifying which sample
OncoTree codes to keep. See "cpt_oncotree_code" column
of data_cohort argument above to get options.}

\item{sample_type}{character specifying which type of genomic sample
to prioritize, options are "Primary", "Local" and "Metastasis".
Default is to not select a NGS sample based on the sample type.}

\item{min_max_time}{character specifying if the first or last genomic
sample recorded should be kept.
Options are "min" (first) and "max" (last).}
}
\value{
returns the 'cohort_ngs' object of the create_analytic_cohort
with unique genomic samples taken from each patients.
}
\description{
For patients with multiple next generation (NGS) sequencing reports,
select one unique NGS report per patient based on several potential criteria.
}
\details{
See the
\href{https://genie-bpc.github.io/genieBPC/articles/select_unique_ngs_vignette.html}{select_unique_ngs vignette}
for further documentation and examples.
}
\examples{
\dontshow{if (genieBPC::.is_connected_to_genie()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Example 1 ----------------------------------
# Create a cohort of all patients with stage IV NSCLC of
# histology adenocarcinoma
nsclc_2_0 <- pull_data_synapse("NSCLC", version = "v2.0-public")

ex1 <- create_analytic_cohort(
  data_synapse = nsclc_2_0$NSCLC_v2.0,
  stage_dx = c("Stage IV"),
  histology = "Adenocarcinoma"
)

# select unique next generation sequencing reports for those patients
samples_data1 <- select_unique_ngs(
  data_cohort = ex1$cohort_ngs,
  oncotree_code = "LUAD",
  sample_type = "Metastasis",
  min_max_time = "max"
)

# Example 2 ----------------------------------
# Create a cohort of all NSCLC patients who
# received Cisplatin, Pemetrexed Disodium or Cisplatin,
# Etoposide as their first drug regimen
ex2 <- create_analytic_cohort(
  data_synapse = nsclc_2_0$NSCLC_v2.0,
  regimen_drugs = c(
    "Cisplatin, Pemetrexed Disodium",
    "Cisplatin, Etoposide"
  ),
  regimen_order = 1,
  regimen_order_type = "within regimen"
)

samples_data2 <- select_unique_ngs(
  data_cohort = ex2$cohort_ngs,
  oncotree_code = "LUAD",
  sample_type = "Metastasis",
  min_max_time = "max"
)
\dontshow{\}) # examplesIf}
}
