% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_kinship.R
\name{tidy_kinship}
\alias{tidy_kinship}
\title{Create a tidy version of a kinship matrix}
\usage{
tidy_kinship(kinship, sort = TRUE)
}
\arguments{
\item{kinship}{The \code{n}-by-\code{n} symmetric kinship matrix}

\item{sort}{If \code{TRUE} (default), rows are sorted ascending by kinship value.
Otherwise, order is moving along the upper triangle row-by-row}
}
\value{
A tibble with \code{n * ( n + 1 ) / 2} rows (the upper triangle, including the diagonal), and 3 columns with names: \code{id1}, \code{id2}, \code{kinship}.
}
\description{
A square symmetric kinship matrix is transformed into a tibble, with a row per unique element in the kinship matrix, and three columns: ID of row, ID of column, and the kinship value.
}
\examples{
# create a symmetric matrix
kinship <- matrix(
    c(
        0.5, 0.1, 0.0,
        0.1, 0.5, 0.2,
        0.0, 0.2, 0.6
    ),
    nrow = 3
)
# add names (best for tidy version)
colnames(kinship) <- paste0('pop', 1:3)
rownames(kinship) <- paste0('pop', 1:3)
# this returns tidy version
kinship_tidy <- tidy_kinship( kinship )
# test colnames
stopifnot( colnames( kinship_tidy ) == c('id1', 'id2', 'kinship') )
# test row number
stopifnot( nrow( kinship_tidy ) == 6 )
# inspect it
kinship_tidy

}
