% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SequenomMarkers_v3.R
\name{SequenomMarkers}
\alias{SequenomMarkers}
\title{R wrapper script to run Sequenom Marker design pipeline}
\usage{
SequenomMarkers(vcf1 = NULL, vcf2 = NULL, outdir = NULL,
  platform = "sq")
}
\arguments{
\item{vcf1}{this is an uncompressed vcf file (Ref allele)}

\item{vcf2}{this is an uncompressed vcf file (Alt allele)}

\item{outdir}{this is where the tab-delimited extended bed file will
be written}

\item{platform}{is a character vector taking "sq" for sequenom (100 bp reference flanking region) or "gg" for goldengate (50 bp reference flanking region).}
}
\value{
SequenomMarker design into "outdir"
}
\description{
\code{SequenomMarkers} runs the SNP genotyping marker design
portion of the genotypeR pipeline.

This function designs Sequenom markers.
}
\examples{

\dontrun{
example_files <- system.file("SequenomMarkers_v2/two_sample/test_files", package = "genotypeR")

vcf1 <- paste(example_files, "Sample1.vcf", sep="/")
vcf2 <- paste(example_files, "Sample2.vcf", sep="/")

##look in outdir to look at the results in Master_SNPs.sorted.txt.
outdir <- paste(example_files, "test_dir", sep="/")

SequenomMarkers(vcf1, vcf2, outdir, platform="sq")

}

}
\keyword{SequenomMarker}
