% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/29_fun_multigroup.R
\name{multigroup.pls}
\alias{multigroup.pls}
\title{PATHMOX-PLS: Extended Segmentation Trees in 
Partial Least Squares Structutal Equation Modeling (PLS-SEM)}
\usage{
multigroup.pls(
  x,
  inner,
  outer,
  mode,
  scheme = "path",
  scaled = TRUE,
  cat,
  ng = 500,
  method = "parametric",
  ...
)
}
\arguments{
\item{x}{matrix or data frame containing the manifest variables.}

\item{inner}{A square (lower triangular) boolean matrix representing 
the inner model (i.e. the path relationships between latent variables).}

\item{outer}{list of vectors with column indices or column names
from \code{x} indicating the sets of manifest variables forming 
each block (i.e. which manifest variables correspond to each block).}

\item{mode}{character vector indicating the type of measurement for each
block. Possible values are: \code{"A", "B", "newA", "PLScore", "PLScow"}. 
The length of \code{mode} must be equal to the length of \code{outer}.}

\item{scheme}{string indicating the type of inner weighting
scheme. Possible values are \code{"centroid"}, \code{"factorial"}, or
\code{"path"}.By default is \code{"path"}.}

\item{scaled}{whether manifest variables should be standardized. 
By the default (\code{TRUE}, scaled to standardized values (mean=0 and variance=1).}

\item{cat}{the caterogical variable used for the comparison.}

\item{ng}{number of resamplig used to calculate the test}

\item{method}{is the method used to test differences in path coefficients. There
are two test availables: the parametric test and the permutation test By
defalut is equal to \code{parametric}.}

\item{\dots}{Further arguments passed on to \code{\link{multigroup.pls}}.}
}
\value{
Basically a list with the
following results:

\item{global_and_group_path_coeff}{Path coefficients estimated for the global and the local models 
defined according to the level of teh categorical variable}

\item{abs_path_diff}{absolute difference of the path coefficients estimated for the local models}

\item{multigroup_pvalue}{LP-value test of comparison}
}
\description{
The function \code{multigroup.pls} performs a group comparison test for comparing 
path coefficients between two groups (classical multigroup approach for PLS-SEM). 
The null and alternative hypotheses to be tested are: H0: path coefficients are not 
significantly different; H1: path coefficients are significantly different
}
\details{
The argument \code{x} must be a data frame containing the manifest variables of the 
PLS-SEM model.

The argument \code{cat} must be the caterogical variable used for teh comparison. 

\code{ng} number of resampling. 

The argument \code{method} is a string contaning the criterion used to calculate the   
tests; if \code{method="parametric"} the classic parametric approach is used to perform the tests; 
if \code{method="permutation"} the Chin 2003 permutation testis used.
}
\references{
Hair, J. F. et al.(2018) \emph{Advanced issues in partial least squares structural equation modeling}. 
Thousand Oaks: SAGE Publications (2018)
}
\author{
Giuseppe Lamberti
}
