% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/logistic_power_function_linear_environment_interaction.R
\name{ss_linear_envir.calc.logistic_outcome}
\alias{ss_linear_envir.calc.logistic_outcome}
\title{Function to Calculate Sample Size for Linear Models with logistic environment interaction}
\usage{
ss_linear_envir.calc.logistic_outcome(
  power = NULL,
  MAF = NULL,
  OR_G = NULL,
  OR_E = NULL,
  OR_GE = NULL,
  sd_e = NULL,
  Case.Rate = NULL,
  k = NULL,
  Alpha = 0.05,
  True.Model = "All",
  Test.Model = "All"
)
}
\arguments{
\item{power}{Vector of the desired power(s)}

\item{MAF}{Vector of minor allele frequencies}

\item{OR_G}{Vector of genetic odds ratios to detect}

\item{OR_E}{Vector of environmental odds ratios to detect}

\item{OR_GE}{Vector of genetic/environmental interaction odds ratios to detect}

\item{sd_e}{Standard deviation of the environmental variable}

\item{Case.Rate}{Standard deviation of the outcome in the population (ignoring genotype). Either Case.Rate_x or Case.Rate must be specified.}

\item{k}{Vector of the number of controls per case. Either k or Case.Rate must be specified.}

\item{Alpha}{the desired type 1 error rate(s)}

\item{True.Model}{A vector specifying the true underlying genetic model(s): 'Dominant', 'Additive', 'Recessive' or 'All'}

\item{Test.Model}{A vector specifying the assumed genetic model(s) used in testing: 'Dominant', 'Additive', 'Recessive' or 'All'}
}
\value{
A data frame including the power for all combinations of the specified parameters (Case.Rate, ES, Power, etc)
}
\description{
Calculates the power to detect an difference in means/effect size/regression coefficient, at a given sample size, N, with type 1 error rate, Alpha
}
\examples{
ss <- ss_linear_envir.calc.logistic_outcome(power=0.8, 
	OR_G=1.1, OR_E=1.2, OR_GE=1.5, 
	sd_e = 1, MAF=0.2, Case.Rate = 0.2,
	Alpha=0.05, True.Model="All", Test.Model="All")


}
