% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_size_function_environment_interaction.R
\name{ss_envir.calc}
\alias{ss_envir.calc}
\title{Function to Calculate Power for Logistic Models with Environment Interaction}
\usage{
ss_envir.calc(
  power = 0.8,
  Case.Rate = NULL,
  k = NULL,
  MAF = NULL,
  OR_G = NULL,
  OR_E = NULL,
  OR_GE = NULL,
  P_e = NULL,
  Alpha = 0.05,
  True.Model = "All",
  Test.Model = "All"
)
}
\arguments{
\item{power}{Vector of the desired power(s)}

\item{Case.Rate}{proportion of cases in the sample (cases/(cases + controls)).}

\item{k}{Vector of the number of controls per case. Either k or Case.Rate must be specified.}

\item{MAF}{Vector of minor allele frequencies}

\item{OR_G}{Vector of genetic odds ratios to detect}

\item{OR_E}{Vector of environmental odds ratios to detect}

\item{OR_GE}{Vector of genetic/environmental interaction odds ratios to detect}

\item{P_e}{Vector of proportions of the population with exposure to the environmental effect}

\item{Alpha}{the desired type 1 error rate(s)}

\item{True.Model}{A vector specifying the true underlying genetic model(s): 'Dominant', 'Additive1', 'Additive2', 'Recessive' or 'All'}

\item{Test.Model}{A vector specifying the assumed genetic model(s) used in testing: 'Dominant', 'Additive', 'Recessive' or 'All'}
}
\value{
A data frame including the power for all combinations of the specified parameters (Case.Rate, ES, Power, etc)
}
\description{
Calculates the power to detect an difference in means/effect size/regression coefficient, at a given sample size, N, with type 1 error rate, Alpha
}
\examples{
ssc <- ss_envir.calc(P_e = 0.2, MAF = 0.1, power = 0.6, Case.Rate = 0.5, Alpha = 0.05, 
	OR_G = 1.5, OR_E = 2, OR_GE = 1.8, Test.Model = "All", True.Model = "All")


}
