% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genscore.R
\name{mu_sigmasqhat}
\alias{mu_sigmasqhat}
\title{Estimates the mu and sigma squared parameters from a univariate truncated normal sample.}
\usage{
mu_sigmasqhat(x, mode, param1, param2, mu = NULL, sigmasq = NULL)
}
\arguments{
\item{x}{A vector, the data.}

\item{mode}{A string, the class of the \code{h} function.}

\item{param1}{A number, the first parameter to the \code{h} function.}

\item{param2}{A number, the second parameter (may be optional depending on \code{mode}) to the \code{h} function.}

\item{mu}{A number, may be \code{NULL}. If \code{NULL}, an estimate will be given; otherwise, the value will be treated as the known true \code{mu} parameter and is used to calculate an estimate for \code{sigmasq}, if \code{sigmasq} is \code{NULL}.}

\item{sigmasq}{A number, may be \code{NULL}. If \code{NULL}, an estimate will be given; otherwise, the value will be treated as the known true \code{sigmasq} parameter and is used to calculate an estimate for \code{mu}, if \code{mu} is \code{NULL}.}
}
\value{
A vector that contains the \code{mu} and the \code{sigmasq} estimates.
}
\description{
Estimates the mu and sigma squared parameters from a univariate truncated normal sample.
}
\details{
If both \code{mu} and \code{sigmasq} are provided, they are returned immediately. If neither is provided, the estimates are given as \deqn{[1/\sigma^2,\mu/\sigma^2]=\left\{\sum_{i=1}^nh(X_i)[X_i,-1][X_i,-1]^{\top}\right\}^{-1}\left\{\sum_{i=1}^n\left[h(X_i)+h'(X_i)X_i,-h'(X_i)\right]\right\}.}{[1/\sigma^2,\mu/\sigma^2]=(sum(h(Xi)*[Xi,-1][Xi,-1]'))^(-1) (sum([h(Xi)+h'(Xi)Xi, -h'(Xi)])).} If only \code{sigmasq} is provided, the estimate for \code{mu} is given as \deqn{\sum_{i=1}^n[h(X_i)X_i-\sigma^2 h'(X_i)]/\sum_{i=1}^nh(X_i).}{sum(h(Xi)Xi-\sigma^2*h'(Xi))/sum(h(Xi)).} If only \code{mu} is given, the estimate for \code{sigmasq} is given as \deqn{\sum_{i=1}^n h(X_i)(X_i-\mu)^2/\sum_{i=1}^n[h(X_i)+h'(X_i)(X_i-\mu)].}{sum(h(Xi)(Xi-\mu)^2)/(sum(h(Xi)+h'(Xi)(Xi-\mu))).}
}
