% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.gensvm.R
\name{predict.gensvm}
\alias{predict.gensvm}
\title{Predict class labels with the GenSVM model}
\usage{
\method{predict}{gensvm}(object, newdata, add.rownames = FALSE, ...)
}
\arguments{
\item{object}{Fitted \code{gensvm} object}

\item{newdata}{Matrix of new data for which predictions need to be made.}

\item{add.rownames}{add the rownames from the training data to the 
predictions}

\item{\dots}{further arguments are ignored}
}
\value{
a vector of class labels, with the same type as the original class 
labels.
}
\description{
This function predicts the class labels of new data using a 
fitted GenSVM model.
}
\examples{
x <- iris[, -5]
y <- iris[, 5]

# create a training and test sample
attach(gensvm.train.test.split(x, y))
fit <- gensvm(x.train, y.train)

# predict the class labels of the test sample
y.test.pred <- predict(fit, x.test)

# compute the accuracy with gensvm.accuracy
gensvm.accuracy(y.test, y.test.pred)

}
\references{
Van den Burg, G.J.J. and Groenen, P.J.F. (2016). \emph{GenSVM: A Generalized 
Multiclass Support Vector Machine}, Journal of Machine Learning Research, 
17(225):1--42. URL \url{http://jmlr.org/papers/v17/14-526.html}.
}
\seealso{
\code{\link{plot.gensvm}}, \code{\link{predict.gensvm.grid}}, 
\code{\link{gensvm}}, \code{\link{gensvm-package}}
}
\author{
Gerrit J.J. van den Burg, Patrick J.F. Groenen \cr
Maintainer: Gerrit J.J. van den Burg <gertjanvandenburg@gmail.com>
}
