% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cells.R
\name{cells_search_format}
\alias{cells_search_format}
\title{Format Cell Search Results for Query Based on Lineage}
\usage{
cells_search_format(cell_list, cells_lineages = "both")
}
\arguments{
\item{cell_list}{A list of cells, each including details such as \code{cell_id} and \code{marker_score},
and optionally containing nested lists of child cells.}

\item{cells_lineages}{A character string specifying the lineage subset to include in the output.
Options are "parent" for only parent cells, "childs" for only child cells, and "both"
for including both parent and child cells. Defaults to "both".}
}
\value{
A named list where keys are \code{cell_id}s and values are strings formatted as conditions
on the \code{marker_score}. This list can be used for constructing query conditions
in further API requests.
}
\description{
This function formats the results from cell search queries into a structured list
based on specified lineage criteria. It allows subsetting of the cell data to include
parent cells, child cells, or both in the output, and converts them into a named list
where each key is a \code{cell_id} and each value is a string representing a condition on
the \code{marker_score}.
}
\examples{
cells <- list(
  list(cell_id = "CL0000235", cell_name = "macrophage", 
  marker_score = 1112.325, childs = list()),
  list(cell_id = "CL0000784", cell_name = "plasmacytoid dendritic cell", 
  marker_score = 537.7737, childs = list(
    list(cell_id = "CL0001058", cell_name = "plasmacytoid dendritic cell, human", 
  marker_score = 262.985)
  ))
)
formatted_query_values <- cells_search_format(cells, cells_lineages = "both")
print(formatted_query_values)
}
