% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gvmerge.r
\name{gvmerge}
\alias{gvmerge}
\title{merge two datasets}
\usage{
gvmerge(data, on, kind = "left", ...)
}
\arguments{
\item{data}{dataset to merge in, either an R data frame, a csv file name, or a dta (Stata) file name.}

\item{on}{a variable list to merge on with the form "var1 var2 var3" (or possibly unquoted if a single variable).}

\item{kind}{one of "left", "right", "outer", or "inner" (default: "left")}

\item{...}{extra options to pass to \code{read.csv} or \code{read.dta} (for old Stata files) or \code{read.dta13} (for newer ones).}
}
\value{
returns NULL, invisibly
}
\description{
Merges two datasets using either a left (keep all elements in current datasets and replace with missing if not present in new set), right (keep all elements in new dataset), outer (keep all observations in both datasets), or inner join (only keep elements in both datasets)
}
\examples{
library(plm)
data(Produc)
use(Produc, clear=TRUE)
collapse(mean(emp), year)
rename(mean(emp), avgemp)
gvmerge(Produc, on="year", kind="right")
listif()
}
