% Generated by roxygen2 (4.0.1.99): do not edit by hand
\name{ebsglmm}
\alias{ebsglmm}
\title{Empirical Bayes estimation for SGLMM}
\usage{
ebsglmm(formula, family = c("gaussian", "binomial", "poisson", "Gamma"), data,
  weights, subset, atsample, parameters, estimate, corrfcn = c("matern",
  "spherical", "power"), Nout, Nthin = 1, Nbi = 0, Npro, Nprt = 1,
  Nprb = 0, betm0, betQ0, ssqdf, ssqsc, zstart, dispersion = 1,
  bfsize1 = 0.8, reference = 1, bfmethod = c("RL", "MW"), useCV = TRUE,
  longlat = FALSE, control = list(), verbose = TRUE)
}
\arguments{
\item{formula}{A representation of the model in the form
\code{response ~ terms}. The response must be set to \code{NA}'s
at the prediction locations. At the observed locations the
response is assumed to be a total of replicated measurements. The
number of replications is inputted using the argument
\code{weights}.}

\item{family}{The distribution of the data.}

\item{data}{An optional data frame containing the variables in the
model.}

\item{weights}{An optional vector of weights. Number of replicated
samples for Gaussian and gamma, number of trials for binomial,
time length for Poisson.}

\item{subset}{An optional vector specifying a subset of
observations to be used in the fitting process.}

\item{atsample}{A formula in the form \code{~ x1 + x2 + ... + xd}
with the coordinates of the sampled locations.}

\item{parameters}{A named list with the components "linkp", "phi",
"omg", "kappa" with all components being vectors of the same
length k. Then, k different MCMC samples will be taken from the
models with parameters fixed at those values. For a square grid
the function \code{\link[base]{expand.grid}} can be useful.}

\item{estimate}{A named list with the components "linkp", "phi",
"omg", "kappa". Each component must be numeric with length 1, 2,
or 3 with elements in increasing order but for the binomial family
linkp is also allowed to be the character "logit" and "probit". If
its length is 1, then the corresponding parameter is considered to
be fixed at that value. If 2, then the two numbers denote the
lower and upper bounds for the optimisation of that parameter
(infinities are allowed). If 3, these correspond to lower bound,
starting value, upper bound for the estimation of that parameter.}

\item{corrfcn}{Spatial correlation function.}

\item{Nout}{A scalar or vector of size k. Number of MCMC samples
to take for each run of the MCMC algorithm for the estimation of
the Bayes factors. See argument
\code{parameters}.}

\item{Nthin}{A scalar or vector of size k. The thinning of the
MCMC algorithm for the estimation of the Bayes factors.}

\item{Nbi}{A scalar or vector of size k. The burn-in of the MCMC
algorithm for the estimation of the Bayes factors.}

\item{Npro}{A scalar. The number of Gibbs samples to use for
estimation of the parameters at the last stage and for prediction
at the unsampled locations.}

\item{Nprt}{The thinning of the Gibbs algorithm.}

\item{Nprb}{The burn-in of the Gibbs algorithm.}

\item{betm0}{Prior mean for beta (a vector or scalar).}

\item{betQ0}{Prior standardised precision (inverse variance)
matrix.}

\item{ssqdf}{Degrees of freedom for the scaled inverse chi-square
prior for the partial sill parameter.}

\item{ssqsc}{Scale for the scaled inverse chi-square prior for the
partial sill parameter.}

\item{zstart}{Starting value for the MCMC for the GRF. Defaults to
0.}

\item{dispersion}{The fixed dispersion parameter.}

\item{bfsize1}{A scalar or vector of the same length as \code{...}
with all integer values or all values in (0, 1]. How many samples
(or what proportion of the sample) to use for estimating the Bayes
factors at the first stage. The remaining sample will be used for
estimating the Bayes factors in the second stage. Setting it to 1
will perform only the first stage.}

\item{reference}{Which model goes in the denominator of the Bayes
factors.}

\item{bfmethod}{Which method to use to calculate the Bayes
factors: Reverse logistic or Meng-Wong.}

\item{useCV}{Whether to use control variates for finer
corrections.}

\item{longlat}{How to compute the distance between locations. If
\code{FALSE}, Euclidean distance, if \code{TRUE} Great Circle
distance. See \code{\link[sp]{spDists}}.}

\item{control}{A list of control parameters for the optimisation.
See \code{\link[stats]{optim}}.}

\item{verbose}{Whether to print messages when completing each
stage on screen.}
}
\value{
A list with components
\itemize{
\item \code{parest} The parameter estimates
\item \code{skeleton} The skeleton points used augmented with the
logarithm of the Bayes factors at those points.
\item \code{optim} The output from the \code{\link[stats]{optim}}
function.
\item \code{mcmcsample} The MCMC samples for the remaining
parameters and the random field.
\item \code{sys_time} The time taken to complete the MCMC
sampling, calculation of the importance weights, the
optimization and the final MCMC sampling.
}
}
\description{
Empirical Bayes estimation for SGLMM
}
\details{
Runs the MCMC sampling, computes the importance weights, and
estimates the parameters.
}

