% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothing.R
\name{coef_fourier}
\alias{coef_fourier}
\title{Computing coefficients Fourier.}
\usage{
coef_fourier(f, m)
}
\arguments{
\item{f}{A time series to be smoothed.}

\item{m}{Order of the Fourier polynomial. Default value is computed using
the Sturge's rule.}
}
\value{
A vector with the fourier coefficients.
}
\description{
This function computes minimum square estimates for Fourier coefficients.
}
\examples{
x <- seq(from = -pi, to = pi, by = 0.01)
y <- x^2 + rnorm(length(x), sd = 0.1)
v_coef <- coef_fourier(y)
}
