% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-ImportFuns.R
\name{spc.Read_ASD}
\alias{spc.Read_ASD}
\title{Read the ASD Spectra from text file}
\usage{
spc.Read_ASD(filename)
}
\arguments{
\item{filename}{A \code{string} name of the input text file containing the raw ASD data.}
}
\value{
Returns an object of class \code{Spectra}.
}
\description{
Imports ASD spectra from text files prepared by the software provided by ASD inc. 
This function imports only one spectra per file.
}
\examples{
filename = file.path(system.file(package = "geoSpectral"),"test_data", "106.064.txt")
L = spc.Read_ASD(filename)
class(L)
spc.plot.plotly(L)

}
