% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\name{spc.plot.map.rbokeh}
\alias{spc.plot.map.rbokeh}
\alias{spc.plot.map.rbokeh,Spectra-method}
\title{Display a Spectra object}
\usage{
spc.plot.map.rbokeh(
  sp,
  glyph = 2,
  color = "#FF0000",
  legend = NULL,
  hover = "row",
  opacity = 1
)

\S4method{spc.plot.map.rbokeh}{Spectra}(
  sp,
  glyph = 2,
  color = "#FF0000",
  legend = NULL,
  hover = "row",
  opacity = 1
)
}
\arguments{
\item{sp}{\code{Spectra} object}

\item{glyph}{Value(s) or field name of the glyph to
use \code{\link{point_types}}}

\item{color}{Determine color of points}

\item{legend}{not implemented  yet}

\item{hover}{String or vector of strings giving column 
names of \code{Spectra} object. This information will be displayed when 
hovering over the glyph}

\item{opacity}{The opacity transparency of the glyph 
between 0 (transparent) and 1 (opaque)}
}
\description{
Create a point map with rbokeh engine using \code{Spectra} rows
}
\examples{
\dontrun{
  sp=spc.example_spectra()
  spc.plot.map.rbokeh(sp, hover = "Snap")
  spc.plot.map.rbokeh(sp)
}

}
