% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_amazon.R
\name{read_amazon}
\alias{read_amazon}
\title{Download official data of Brazil's Legal Amazon as an sf object.}
\usage{
read_amazon(year = NULL)
}
\arguments{
\item{year}{A date number in YYYY format (defaults to 2012)}
}
\description{
This data set covers the whole of Brazil's Legal Amazon as defined in the federal law n. 12.651/2012). The original
data comes from the Brazilian Ministry of Environment (MMA) and can be found at http://mapas.mma.gov.br/i3geo/datadownload.htm .
}
\examples{
\donttest{

library(geobr)

# Read Brazilian Legal Amazon
  a <- read_amazon(year=2012)
}

}
\seealso{
Other general area functions: \code{\link{read_biomes}},
  \code{\link{read_census_tract}},
  \code{\link{read_conservation_units}},
  \code{\link{read_country}},
  \code{\link{read_immediate_region}},
  \code{\link{read_intermediate_region}},
  \code{\link{read_meso_region}},
  \code{\link{read_micro_region}},
  \code{\link{read_municipality}},
  \code{\link{read_region}}, \code{\link{read_semiarid}},
  \code{\link{read_state}},
  \code{\link{read_statistical_grid}},
  \code{\link{read_weighting_area}}
}
\concept{general area functions}
