% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_functions.R
\name{eval_parameters}
\alias{eval_parameters}
\title{Worker function}
\usage{
eval_parameters(
  algo,
  parameters,
  data,
  nblistw = NULL,
  standardize = TRUE,
  spconsist = FALSE,
  classidx = TRUE,
  tol,
  maxiter,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{algo}{A string indicating which method to use (FCM, GFCM, SFCM, SGFCM)}

\item{parameters}{A dataframe of parameters with columns k,m and alpha}

\item{data}{A dataframe with numeric columns}

\item{nblistw}{A list.w object describing the neighbours typically produced
by the spdep package}

\item{standardize}{A boolean to specify if the variable must be centered and
reduce (default = True)}

\item{spconsist}{A boolean indicating if the spatial consistency must be
calculated}

\item{classidx}{A boolean indicating if the quality of classification
indices must be calculated}

\item{tol}{The tolerance criterion used in the evaluateMatrices function for
convergence assessment}

\item{maxiter}{An integer for the maximum number of iteration}

\item{seed}{An integer used for random number generation. It ensures that the
start centers will be the same if the same integer is selected.}

\item{verbose}{A boolean indicating if a progressbar should be displayed}
}
\value{
a DataFrame containing for each combinations of parameters several clustering
quality indexes.
}
\description{
Worker function for select_parameters and select_parameters.mc
}
\examples{
#No example provided, this is an internal function
}
\keyword{internal}
