% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocd_raster.R
\name{geocd_raster}
\alias{geocd_raster}
\title{geocomplexity for spatial raster data based on spatial dependence}
\usage{
geocd_raster(r, order = 1, normalize = TRUE, method = "moran")
}
\arguments{
\item{r}{\code{SpatRaster} object or can be converted to \code{SpatRaster} by \code{terra::rast()}.}

\item{order}{(optional) The order of the adjacency object. Default is \code{1}.}

\item{normalize}{(optional) Whether to further normalizes the calculated geocomplexity.
Default is \code{TRUE}.}

\item{method}{(optional) In instances where the method is \code{moran}, geocomplexity is
determined using local moran measure method. Conversely, when the method is \code{spvar},
the spatial variance of attribute data serves to characterize geocomplexity. For all
other methods, the shannon information entropy of attribute data is employed to represent
geocomplexity. The selection of the method can be made from any one of the three options:
\code{moran}, \code{spvar} or \code{entropy}. Default is \code{moran}.}
}
\value{
A SpatRaster object
}
\description{
This function calculates geocomplexity for spatial raster data based on spatial dependence.
}
\note{
In contrast to the \code{geocd_vector()} function, the \code{geocd_raster()} performs operations
internally on raster data based on neighborhood operations(focal) without providing
additional wt object.
}
\examples{
library(terra)
m = matrix(c(3,3,3,3,1,3,
             3,3,3,2,1,2,
             3,3,3,1,2,1,
             1,3,2,2,2,2,
             2,2,2,1,1,2,
             1,2,1,1,1,1),
           nrow = 6,
           byrow = TRUE)
m = rast(m)
names(m) = 'sim'
plot(m, col = c("#d2eaac", "#a3dae1", "#8cc1e1"))
gc1 = geocd_raster(m,1)
gc2 = geocd_raster(m,2)
gc1
plot(gc1)
gc2
plot(gc2)

}
\references{
Zehua Zhang, Yongze Song, Peng Luo & Peng Wu (2023) Geocomplexity explains spatial errors,
International Journal of Geographical Information Science, 37:7, 1449-1469,
DOI: 10.1080/13658816.2023.2203212

Anselin, L. (2019). A local indicator of multivariate spatial association: Extending
geary’s c. Geographical Analysis, 51(2), 133–150. https://doi.org/10.1111/gean.12164
}
