% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot3dXyz.r
\docType{methods}
\name{plot3dXyz}
\alias{plot3d}
\alias{plot3dXyz}
\alias{plot3dXyz,Profile-method}
\alias{plot3dXyz,ProfileSet-method}
\title{Plots Profiles 3D}
\usage{
plot3dXyz(.Object, title = "", sub = "", xlab = "", ylab = "",
  zlab = "", minData = 0, maxData = 9999999, col = colors,
  trafo = log, psize = pointsize)

\S4method{plot3dXyz}{ProfileSet}(.Object, title = .Object@title, sub = "",
  xlab = "", ylab = "", zlab = "", minData = .Object@minData,
  maxData = .Object@maxData, col = colors, trafo = log,
  psize = pointsize)

\S4method{plot3dXyz}{Profile}(.Object, title = "", sub = "", xlab = "",
  ylab = "", zlab = "", minData = .Object@xyzData@minData,
  maxData = .Object@xyzData@maxData, col = colors, trafo = log,
  psize = pointsize)
}
\arguments{
\item{.Object}{either an object of a single Profile or a ProfileSet.}

\item{title}{title to be plotted.}

\item{sub}{subtitle to be plotted.}

\item{xlab}{label of the x-axes, e.g. length [m].}

\item{ylab}{label of the y-axes, e.g. height above sea level [m].}

\item{zlab}{label of the z-axes, e.g. length [m].}

\item{minData}{mimimum value to adjust color bar.}

\item{maxData}{maximum value to adjust color bar.}

\item{col}{vector of colors.}

\item{trafo}{transformation to be done on data (default: log).}

\item{psize}{size of value points (default: 10).}
}
\description{
Plots the interpolated resistance values of the 
xyz data for all profiles.
}
\examples{
# data(sinkhole)

# plot3dXyz(sinkhole@profiles[[1]])
# plot3dXyz(sinkhole)
}
\seealso{
\code{\link{Profile-class}}, \code{\link{ProfileSet-class}},
\code{\link{plotXyz}}, \code{\link{levelplotXyz}}
}

