% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_docs.R
\docType{data}
\name{grids}
\alias{grids}
\alias{us_state_grid1}
\alias{us_state_grid2}
\alias{eu_grid1}
\alias{aus_grid1}
\alias{sa_prov_grid1}
\alias{london_boroughs_grid}
\alias{nhs_scot_grid}
\alias{india_grid1}
\alias{india_grid2}
\alias{argentina_grid1}
\alias{br_grid1}
\alias{sea_grid1}
\alias{mys_grid1}
\alias{fr_regions_grid1}
\alias{de_states_grid1}
\alias{or_counties_grid1}
\alias{wa_counties_grid1}
\alias{in_counties_grid1}
\alias{in_central_counties_grid1}
\alias{se_counties_grid1}
\alias{sf_bay_area_counties_grid1}
\alias{ua_region_grid1}
\alias{mx_state_grid1}
\alias{mx_state_grid2}
\alias{scotland_local_authority_grid1}
\alias{us_state_grid3}
\alias{italy_grid1}
\alias{italy_grid2}
\title{Geo Grids}
\usage{
us_state_grid1

us_state_grid2

eu_grid1

aus_grid1

sa_prov_grid1

london_boroughs_grid

nhs_scot_grid

india_grid1

india_grid2

argentina_grid1

br_grid1

sea_grid1

mys_grid1

fr_regions_grid1

de_states_grid1

or_counties_grid1

wa_counties_grid1

in_counties_grid1

in_central_counties_grid1

se_counties_grid1

sf_bay_area_counties_grid1

ua_region_grid1

mx_state_grid1

mx_state_grid2

scotland_local_authority_grid1

us_state_grid3

italy_grid1

italy_grid2
}
\description{
There are now 28 grids available in this package and more online. To view a full list of available grids, see \href{https://raw.githubusercontent.com/hafen/grid-designer/master/grid_list.json}{here}. To create and submit your own grid, see \href{https://hafen.github.io/grid-designer/}{here}. To see several examples of grids being used to visualize data, see \code{\link{facet_geo}}.

\itemize{
\item \strong{us_state_grid1:} Grid layout for US states (including DC) Image reference \href{https://images7.alphacoders.com/687/687665.jpg}{here}.
}

\itemize{
\item \strong{us_state_grid2:} Grid layout for US states (including DC) Image reference \href{https://images7.alphacoders.com/687/687665.jpg}{here}.
}

\itemize{
\item \strong{eu_grid1:} Grid layout for the 28 EU Countries Image reference \href{https://ichef.bbci.co.uk/news/660/media/images/70233000/gif/_70233868_eunames.gif}{here}.
}

\itemize{
\item \strong{aus_grid1:} Grid layout for the Australian States and Territories. Image reference \href{https://cloud.githubusercontent.com/assets/9496865/26334627/75a729d2-3fa5-11e7-88af-a1dd86b7ddf3.png}{here}. Thanks to \href{https://github.com/jonocarroll}{jonocarroll}.
}

\itemize{
\item \strong{sa_prov_grid1:} Grid layout for the provinces of South Africa Image reference \href{https://camo.githubusercontent.com/a90b18a1ab0c36200da9b118141b997b3f22638e/687474703a2f2f7777772e6578706c6f7265736f7574686166726963612e6e65742f696d616765732f70726f766d61702e6a7067}{here}. Thanks to \href{https://github.com/jonmcalder}{jonmcalder}.
}

\itemize{
\item \strong{london_boroughs_grid:} Grid layout for the boroughs of London. Note that the column \code{code_ons} contains the \href{http://geoportal.statistics.gov.uk/datasets/464be6191a434a91a5fa2f52c7433333_0?uiTab=table}{codes} used by UK Office for National Statistics. Image reference \href{https://cloud.githubusercontent.com/assets/13021448/26399784/3133d684-4076-11e7-8eac-1e74d023bf18.jpg}{here}. Thanks to \href{https://github.com/eldenvo}{eldenvo}.
}

\itemize{
\item \strong{nhs_scot_grid:} Grid layout for a grid of NHS Scotland Health Boards. Note that the column \code{code} contains the \href{http://geoportal.statistics.gov.uk/datasets/61dca36aa33e4aee99bbfa784fa9eb25_0?uiTab=table}{codes} used by UK Office for National Statistics. Image reference \href{https://cloud.githubusercontent.com/assets/24879214/26426113/253658d0-40cf-11e7-88b5-fe5ee7fda44f.png}{here}. Thanks to \href{https://github.com/jsphdms}{jsphdms}.
}

\itemize{
\item \strong{india_grid1:} Grid layout for India states (not including union territories). Image reference \href{https://cloud.githubusercontent.com/assets/11698124/26569168/dd2ca86c-44bd-11e7-9d74-af919522f7b1.jpg}{here}. Thanks to \href{https://github.com/meysubb}{meysubb}.
}

\itemize{
\item \strong{india_grid2:} Grid layout for India states (not including union territories). Image reference \href{https://cloud.githubusercontent.com/assets/11698124/26569168/dd2ca86c-44bd-11e7-9d74-af919522f7b1.jpg}{here}.
}

\itemize{
\item \strong{argentina_grid1:} Grid for the 23 provinces of Argentina. It includes the Malvinas/Falkland Islands and the Antarctic Territories (these are disputed, but they are included since many researchers might use data from these locations). Image reference \href{https://s-media-cache-ak0.pinimg.com/736x/bf/cb/96/bfcb9654477c127d3b0e0b72d5be65fc.jpg}{here}. Thanks to \href{https://github.com/eliocamp}{eliocamp}.
}

\itemize{
\item \strong{br_grid1:} Grid for the 27 states of Brazil. Image reference \href{https://camo.githubusercontent.com/477627dce2610f18f1bf3850cd32fca01610656e/687474703a2f2f63656a656475696e66616e74696c2e7062776f726b732e636f6d2f662f313435383034313938342f4d61706142726173696c5369676c61732e676966}{here}. Thanks to \href{https://github.com/italocegatta}{italocegatta}.
}

\itemize{
\item \strong{sea_grid1:} Grid for South East Asian countries. Image reference \href{https://camo.githubusercontent.com/694a275db0e89984f347ce8b49221352416d2c48/68747470733a2f2f7669676e65747465322e77696b69612e6e6f636f6f6b69652e6e65742f757461752f696d616765732f382f38322f536f757468656173745f617369612e6a70672f7265766973696f6e2f6c61746573743f63623d3230313130313230303431383034}{here}. Thanks to \href{https://github.com/jasonjb82}{jasonjb82}.
}

\itemize{
\item \strong{mys_grid1:} Grid for Malaysian states and territories. Image reference \href{https://camo.githubusercontent.com/cd22848f0b7b53d4ef7afc6d178a0e9579ecf2aa/68747470733a2f2f7777772e6d6170736f66776f726c642e636f6d2f6d616c61797369612f6d6170732f6d616c61797369612d706f6c69746963616c2d6d61702e6a7067}{here}. Thanks to \href{https://github.com/jasonjb82}{jasonjb82}.
}

\itemize{
\item \strong{fr_regions_grid1:} Land and overseas regions of France. Codes are INSEE codes. Image reference \href{https://camo.githubusercontent.com/b526c357a4c30cdd2e90700c6559381348111377/687474703a2f2f7777772e6361727465736672616e63652e66722f6361727465732f67656f677261706869652f63617274652d726567696f6e732e6a7067}{here}. Thanks to \href{https://github.com/mtmx}{mtmx}.
}

\itemize{
\item \strong{de_states_grid1:} Grid for the German states ('Länder') Image reference \href{https://camo.githubusercontent.com/e144ebb2bdd2d82d8a4c34908cd68ab2b2388425/68747470733a2f2f75706c6f61642e77696b696d656469612e6f72672f77696b6970656469612f636f6d6d6f6e732f642f64332f5374617465735f6f665f4765726d616e792e737667}{here}. Thanks to \href{https://github.com/DominikVogel}{DominikVogel}.
}

\itemize{
\item \strong{or_counties_grid1:} Grid for Oregon counties. Image reference \href{https://user-images.githubusercontent.com/11638312/27445795-01b77804-5730-11e7-919b-36cde8027706.jpg}{here}. Thanks to \href{https://github.com/aosmith16}{aosmith16}.
}

\itemize{
\item \strong{wa_counties_grid1:} Grid for Washington counties. Image reference \href{http://www.countymapsofwashington.com/aapics/washingstate.gif}{here}.
}

\itemize{
\item \strong{in_counties_grid1:} Grid for Indiana counties. Image reference \href{https://upload.wikimedia.org/wikipedia/commons/thumb/e/ec/Indiana_county_map.png/640px-Indiana_county_map.png}{here}. Thanks to \href{https://github.com/nateapathy}{nateapathy}.
}

\itemize{
\item \strong{in_central_counties_grid1:} Grid for central Indiana counties. Image reference \href{https://camo.githubusercontent.com/eb31e821890a0c600f59234fb184335c2bf84423/687474703a2f2f7777772e736176692e6f72672f77702d636f6e74656e742f75706c6f6164732f323031352f30322f6d61702d312e6a7067}{here}. Thanks to \href{https://github.com/nateapathy}{nateapathy}.
}

\itemize{
\item \strong{se_counties_grid1:} Grid for counties of Sweden. Image reference \href{http://www.worldatlas.com/webimage/countrys/europe/lgcolor/secounties.gif}{here}. Thanks to \href{https://github.com/duleise}{duleise}.
}

\itemize{
\item \strong{sf_bay_area_counties_grid1:} Grid of the 9 San Francisco Bay Area counties. Image reference \href{https://user-images.githubusercontent.com/1275592/28043128-53be650a-6585-11e7-920e-4ad9a13bf1a5.png}{here}. Thanks to \href{https://github.com/Eunoia}{Eunoia}.
}

\itemize{
\item \strong{ua_region_grid1:} Grid of administrative divisions of Ukraine (24 oblasts, one autonomous region, and two cities). Image reference \href{https://camo.githubusercontent.com/0615706478de63da2c7c3c3b21fe92c6db6a2fee/687474703a2f2f696d61676573312e66616e706f702e636f6d2f696d616765732f696d6167655f75706c6f6164732f556b7261696e69616e2d6d61702d756b7261696e652d313135333138375f3733305f3530352e676966}{here}. Thanks to \href{https://github.com/woldemarg}{woldemarg}.
}

\itemize{
\item \strong{mx_state_grid1:} Grid layout for the states of Mexico. Image reference \href{https://user-images.githubusercontent.com/1275592/28044555-ee236b2a-658c-11e7-96e5-3af124ca9619.png}{here}. Thanks to \href{https://github.com/ikashnitsky}{ikashnitsky}.
}

\itemize{
\item \strong{mx_state_grid2:} Grid layout for the states of Mexico. Image reference \href{https://user-images.githubusercontent.com/1275592/28044555-ee236b2a-658c-11e7-96e5-3af124ca9619.png}{here}. Thanks to \href{https://github.com/diegovalle}{diegovalle}.
}

\itemize{
\item \strong{scotland_local_authority_grid1:} Grid layout for the local authorities of Scotland. Image reference \href{https://user-images.githubusercontent.com/1275592/28044967-3b508570-658f-11e7-99b5-b1d73c765c2e.png}{here}. Thanks to \href{https://github.com/davidhen}{davidhen}.
}

\itemize{
\item \strong{us_state_grid3:} Grid layout for US states (excluding DC) Image reference \href{https://images7.alphacoders.com/687/687665.jpg}{here}. Thanks to \href{https://github.com/ejr248}{ejr248}.
}

\itemize{
\item \strong{italy_grid1:} Grid layout for regions of Italy (in collaboration with Stella Cangelosi and Luciana Dalla Valle). Image reference \href{https://user-images.githubusercontent.com/1275592/28291015-8f0abd66-6afd-11e7-9e2a-b4c1d4021c13.png}{here}. Thanks to \href{https://github.com/JulianStander}{JulianStander}.
}

\itemize{
\item \strong{italy_grid2:} Grid layout for regions of Italy (in collaboration with Stella Cangelosi and Luciana Dalla Valle). Image reference \href{https://user-images.githubusercontent.com/1275592/28291015-8f0abd66-6afd-11e7-9e2a-b4c1d4021c13.png}{here}. Thanks to \href{https://github.com/JulianStander}{JulianStander}.
}
}
\keyword{data}
