% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign_polygons.R
\name{assign_polygons}
\alias{assign_polygons}
\title{Assign the polygons in the original spatial data to their new location.}
\usage{
assign_polygons(shape, new_polygons)
}
\arguments{
\item{shape}{A "SpatialPolygonsDataFrame" object representing the original spatial polygons.}

\item{new_polygons}{A "geogrid" object returned from \code{\link{calculate_grid}}.}
}
\value{
A SpatialPolygonsDataFrame.
}
\description{
Assigns each polygon in the original file to a new location in the gridded geometry using the Hungarian algorithm.
}
\examples{
\dontrun{
input_file <- system.file("extdata", "london_LA.json", package = "geogrid")
original_shapes <- read_polygons(input_file)

# calculate grid
new_cells <- calculate_grid(shape = original_shapes,
  grid_type = "hexagonal", seed = 1)
plot(new_cells)

#
grid_shapes <- assign_polygons(original_shapes, new_cells)
par(mfrow=c(1, 2))
sp::plot(original_shapes)
sp::plot(grid_shapes)

# look at different grids using different seeds
par(mfrow=c(2, 3), mar = c(0, 0, 2, 0))
for (i in 1:6) {
  new_cells <- calculate_grid(shape = original_shapes, grid_type = "hexagonal", seed = i)
  plot(new_cells, main = paste("Seed", i, sep=" "))
}
}
}
