% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps.R
\name{hci_mean}
\alias{hci_mean}
\title{Calculate mean of raster objects}
\usage{
hci_mean(
  indices,
  global = FALSE,
  east = NULL,
  west = NULL,
  geoscale = NULL,
  res = reso(),
  plt = TRUE,
  outdir = tempdir()
)
}
\arguments{
\item{indices}{List of SpatRasters.
This input represents the spatial raster collection for which mean is to be calculated.}

\item{global}{Logical. \code{TRUE} if global analysis is desired, \code{FALSE} otherwise.
\code{east} and \code{west} are required when \code{TRUE}.}

\item{east}{SpatRaster. Collection of risk indices on eastern extent.}

\item{west}{SpatRaster. Collection of risk indices on western extent.
When \code{TRUE}, \code{geoscale} is ignored. Default is \code{TRUE}.}

\item{geoscale}{Vector. geographical scale. Default is \code{NULL}.}

\item{res}{Numeric. Map resolution. This value is used in aggregation and dis-aggregation operation.
Default is \code{\link[=reso]{reso()}}.}

\item{plt}{\code{TRUE} if need to plot mean map, \code{FALSE} otherwise.}

\item{outdir}{Character. Output directory for saving raster in TIFF format.
Default is \code{\link[=tempdir]{tempdir()}}.}
}
\value{
RiskMap. Contains result in the form of \code{SpatRaster} objects
and file path of the saved maps.
}
\description{
Wrapper for \code{\link[terra:summarize-generics]{terra::mean()}}. Calculates mean of list of rasters.
}
