% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sernanp_data.R
\name{get_sernanp_data}
\alias{get_sernanp_data}
\title{Download the available data from Sernanp}
\usage{
get_sernanp_data(layer = NULL, dsn = NULL, show_progress = TRUE, quiet = FALSE)
}
\arguments{
\item{layer}{Select only one from the list of available layers, for more information please use `get_data_sources(provider = "sernanp")`. Defaults to NULL.}

\item{dsn}{Character. Output filename with the \bold{spatial format}. If missing, a temporary file is created.}

\item{show_progress}{Logical. Suppress bar progress.}

\item{quiet}{Logical. Suppress info message.}
}
\value{
A sf object.
}
\description{
This function allows you to download the latest version of data available on the sernanp geoviewer.
For more information, you can visit the following web page: \url{https://geo.sernanp.gob.pe/visorsernanp/}
}
\examples{
\donttest{
library(geoidep)
library(sf)
anp <- get_sernanp_data(layer = "zonificacion_anp" , show_progress = FALSE)
plot(st_geometry(anp))
}
}
