% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linting.R
\name{linting_opts}
\alias{linting_opts}
\title{GeoJSON Linting}
\usage{
linting_opts(lint = FALSE, method = "hint", error = FALSE)
}
\arguments{
\item{lint}{(logical) lint geojson or not. Default: \code{FALSE}}

\item{method}{(character) method to use:
\itemize{
 \item hint - uses \code{\link[geojsonlint]{geojson_hint}}
 \item lint - uses \code{\link[geojsonlint]{geojson_lint}}
 \item validate - uses \code{\link[geojsonlint]{geojson_validate}}
}}

\item{error}{(logical) Throw an error on parse failure? If \code{TRUE}, then
function returns \code{TRUE} on success, and stop with the error
message on error. Default: \code{FALSE}}
}
\description{
GeoJSON Linting
}
\details{
if you have \pkg{geojsonlint} installed, we can lint
your GeoJSON inputs for you. If not, we skip that step.

Note that even if you aren't linting your geojson with \pkg{geojsonlint},
we still do some minimal checks.
}
\examples{
linting_opts(lint = TRUE)

linting_opts(lint = TRUE, method = "hint")
linting_opts(lint = TRUE, method = "hint", error = TRUE)
linting_opts(lint = TRUE, method = "lint")
linting_opts(lint = TRUE, method = "lint", error = TRUE)
linting_opts(lint = TRUE, method = "validate")
linting_opts(lint = TRUE, method = "validate", error = TRUE)
}

