% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate}
\alias{validate}
\title{Validate a geoJSON file, json object, list, or Spatial class.}
\usage{
validate(x, ...)
}
\arguments{
\item{x}{Input list, data.frame, or spatial class. Inputs can also be dplyr \code{tbl_df}
class since it inherits from \code{data.frame}.}

\item{...}{Further args passed on to helper functions.}
}
\description{
Validate a geoJSON file, json object, list, or Spatial class.
}
\details{
Uses the web service at \url{http://geojsonlint.com/}

This function is Deprecated - and will be removed in the next version of
this package. See \code{\link{geojsonio-deprecated}} for more information
}
\examples{
\dontrun{
# From a json character string
validate(x = '{"type": "Point", "coordinates": [-100, 80]}') # good
validate(x = '{"type": "Rhombus", "coordinates": [[1, 2], [3, 4], [5, 6]]}') # bad

# A file
file <- system.file("examples", "zillow_or.geojson", package = "geojsonio")
validate(x = as.location(file))

# A URL
url <- "https://raw.githubusercontent.com/glynnbird/usstatesgeojson/master/california.geojson"
validate(as.location(url))

# From output of geojson_list
(x <- geojson_list(us_cities[1:2,], lat='lat', lon='long'))
validate(x)

# From output of geojson_json
(x <- geojson_json(us_cities[1:2,], lat='lat', lon='long'))
validate(x)

# From a list turned into geo_list
mylist <- list(list(latitude=30, longitude=120, marker="red"),
               list(latitude=30, longitude=130, marker="blue"))
x <- geojson_list(mylist)
class(x)
validate(x)

# From SpatialPoints class
library("sp")
a <- c(1,2,3,4,5)
b <- c(3,2,5,1,4)
(x <- SpatialPoints(cbind(a,b)))
class(x)
validate(x)
}
}
