% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geojson_sp.R
\name{geojson_sp}
\alias{geojson_sp}
\title{Convert output of \code{geojson_list} or \code{geojson_json} to spatial classes}
\usage{
geojson_sp(x, disambiguateFIDs = FALSE, stringsAsFactors = FALSE, ...)
}
\arguments{
\item{x}{Object of class \code{geo_list} or \code{geo_json}}

\item{disambiguateFIDs}{Ignored, and will be removed in a future version.
Previously was passed to \code{\link[rgdal:readOGR]{rgdal::readOGR()}}, which is no longer used.}

\item{stringsAsFactors}{Convert strings to Factors? Default \code{FALSE}.}

\item{...}{Further args passed on to \code{\link[sf:st_read]{sf::st_read()}}}
}
\value{
A spatial class object, see Details.
}
\description{
Convert output of \code{geojson_list} or \code{geojson_json} to spatial classes
}
\details{
The spatial class object returned will depend on the input GeoJSON.
Sometimes you will get back a \code{SpatialPoints} class, and sometimes a
\code{SpatialPolygonsDataFrame} class, etc., depending on what the
structure of the GeoJSON.

The reading and writing of the CRS to/from geojson is inconsistent. You can
directly set the CRS by passing a valid PROJ4 string or epsg code to the crs
argument in \code{\link[sf:st_read]{sf::st_read()}}
}
\examples{
\dontrun{
library(sp)

# geo_list ------------------
## From a numeric vector of length 2 to a point
vec <- c(-99.74,32.45)
geojson_list(vec) \%>\% geojson_sp

## Lists
## From a list
mylist <- list(list(latitude=30, longitude=120, marker="red"),
               list(latitude=30, longitude=130, marker="blue"))
geojson_list(mylist) \%>\% geojson_sp
geojson_list(mylist) \%>\% geojson_sp \%>\% plot

## From a list of numeric vectors to a polygon
vecs <- list(c(100.0,0.0), c(101.0,0.0), c(101.0,1.0), c(100.0,1.0), c(100.0,0.0))
geojson_list(vecs, geometry="polygon") \%>\% geojson_sp
geojson_list(vecs, geometry="polygon") \%>\% geojson_sp \%>\% plot

# geo_json ------------------
## from point
geojson_json(c(-99.74,32.45)) \%>\% geojson_sp
geojson_json(c(-99.74,32.45)) \%>\% geojson_sp \%>\% plot

# from featurecollectino of points
geojson_json(us_cities[1:2,], lat='lat', lon='long') \%>\% geojson_sp
geojson_json(us_cities[1:2,], lat='lat', lon='long') \%>\% geojson_sp \%>\% plot

# Set the CRS via the crs argument
geojson_json(us_cities[1:2,], lat='lat', lon='long') \%>\%
  geojson_sp(crs = "+init=epsg:4326")

# json ----------------------
x <- geojson_json(us_cities[1:2,], lat='lat', lon='long')
geojson_sp(x)
}
}
