% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/successful.R
\docType{methods}
\name{successful}
\alias{error}
\alias{error,geojob-method}
\alias{running}
\alias{running,geojob-method}
\alias{successful}
\alias{successful,geojob-method}
\title{Convenience function for GDP process state}
\usage{
successful(.Object, retry)
error(.Object, retry)
running(.Object, retry)

\S4method{successful}{geojob}(.Object, retry = FALSE)

\S4method{running}{geojob}(.Object, retry = FALSE)

\S4method{error}{geojob}(.Object, retry = FALSE)
}
\arguments{
\item{.Object}{a \linkS4class{geojob} object}

\item{retry}{attempt to retry again if communication failed with the server}
}
\value{
TRUE/FALSE indicating if process is in the given state (error, processing, successful)
}
\description{
Simple wrapper to check process status
}
\examples{
\dontrun{
wp <- quick_wp()
job <- geoknife(stencil = c(-89,42), fabric = 'prism', knife = wp)
check(job)

running(job)
error(job)
successful(job)
}
}
\author{
Luke Winslow, Jordan S Read
}
\seealso{
\code{\link{check}}
}

