% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02-webgeom-obj.R
\docType{class}
\name{webgeom-class}
\alias{webgeom-class}
\title{webgeom class}
\description{
The \code{webgeom} class represents a web feature service (WFS) dataset.
WFS is an open geospatial consortium standard for spatial data on the web. WFS supports 
filtering of spatial elements and this object can support many of those filters.
}
\section{Slots}{

\describe{
\item{\code{url}}{URL of web feature service endpoint. 
Can be set or accessed using \code{\link[geoknife]{url}}}

\item{\code{geom}}{character for geometric feature name. 
Can be set or accessed using \code{\link[geoknife]{geom}}}

\item{\code{attribute}}{character for feature attribute (used for filtering and naming in output)
Can be set or accessed using \code{\link[geoknife]{attribute}}}

\item{\code{values}}{character vector of attribute values to be used in processing (a subset, or all if NA)
Can be set or accessed using \code{\link[geoknife]{values}}}

\item{\code{version}}{a character that specifies the web feature service (WFS) version to use.
Can be set or accessed using \code{\link[geoknife]{version}}}

\item{\code{GML_IDs}}{(_private) IDs that correspond to \code{values}. Used internally for processing.}

\item{\code{WFS_NAMESPACE}}{(_private) web location of web feature service namespace}

\item{\code{GML_NAMESPACE}}{(_private) web location of GML namespace}

\item{\code{GML_SCHEMA_LOCATION}}{(_private) web location of GML schema location}
}}
\seealso{
\code{\link{webgeom}}, \code{\link[geoknife]{url}}, \code{\link[geoknife]{geom}}, 
\code{\link[geoknife]{attribute}}, \code{\link[geoknife]{values}}, \code{\link[geoknife]{version}}
}

