% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoknife-generic.R
\docType{methods}
\name{geoknife}
\alias{geoknife}
\title{geoknife}
\usage{
geoknife(stencil, fabric, knife = webprocess(...), ...)
}
\arguments{
\item{stencil}{a \code{\link{webgeom}}, \code{\link{simplegeom}}, or any type 
that can be coerced into \code{\link{simplegeom}}.}

\item{fabric}{a dataset. A \code{\link{webdata}} or any type that 
can be coerced into \code{\link{webdata}}}

\item{knife}{(optional) a \code{\link{webprocess}} object}

\item{...}{additional arguments passed to \code{new} \code{\link{webprocess}}. 
Can also be used to modify the \code{knife} argument, if it is supplied.}
}
\value{
and object of class \linkS4class{geojob}
}
\description{
Creates the processing job and allows specifying the processing details.
}
\details{
The \code{stencil} argument is akin to cookie cutter(s), which specify how the dataset is 
to be sub-sampled spatially. Supported types are all geometric in nature, be they collections 
of points or polygons. Because geoprocessing operations require a non-zero area for \code{stencil}, 
if points are used (i.e., the different point collections that can be used in \code{\link{simplegeom}}), 
there is a negligible automatic point buffer applied to each point to result in a non-zero area. 

Naming of the components of the \code{stencil} will impact the formatting of the result returned by 
the geoknife processing job (the \code{\link{geojob}})

geoknife will check the class of the stencil argument, and if stencil's class is not
\code{\link{webgeom}}, it will attempt to coerce the object into a \code{\link{simplegeom}}. 
If no coercion method exists, geoknife will fail. 

The \code{fabric} argument is akin to the dough or fabric that will be subset with the \code{stencil} 
argument. At present, this is a web-available gridded dataset that meets a variety of formatting restrictions. 
Several quick start methods for creating a \code{\link{webdata}} object (only \code{\link{webdata}} or 
an type that can be coerced into \code{\link{webdata}} are valid arguments for \code{fabric}).

Making concurrent requests to the Geo Data Portal will NOT result in faster overall execution times. 
The data backing the system is on high performance storage, but that storage is not meant to support 
parallelized random access and can be significantly slower under these conditions. Read more: 
https://my.usgs.gov/confluence/display/GeoDataPortal/Geo+Data+Portal+Scalability+Guidelines
}
\examples{
\dontrun{
job <- geoknife(stencil = c(-89,42), fabric = 'prism')
check(job)

#-- set up geoknife to email user when the process is complete

job <- geoknife(webgeom("state::Wisconsin"), fabric = 'prism', email = 'fake.email@gmail.com')

}
}
