% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moran.R
\name{local_morans}
\alias{local_morans}
\title{Compute Local Moran's I}
\usage{
local_morans(shp, adj, wts, spatial_mat)
}
\arguments{
\item{shp}{sf data frame. Optional if adj or spatial_mat provided.}

\item{adj}{zero indexed adjacency list. Optional if shp or spatial_mat provided.}

\item{wts}{Required. Numeric vector with weights to use for Moran's I.}

\item{spatial_mat}{matrix of spatial weights. Optional if shp or adj provided.}
}
\value{
tibble
}
\description{
Compute Local Moran's I
}
\examples{
library(dplyr)
data("checkerboard")
checkerboard <- checkerboard \%>\% mutate(m = as.numeric((id+i) \%\% 2 == 0))
local_morans(shp = checkerboard, wts = checkerboard$m)

}
\concept{spatcorr}
