% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ISOIdentification.R
\docType{class}
\name{ISOIdentification}
\alias{ISOIdentification}
\title{ISOIdentification}
\format{\code{\link{R6Class}} object.}
\usage{
ISOIdentification
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Identification
}
\description{
ISOIdentification
}
\section{Fields}{

\describe{
\item{\code{citation}}{}

\item{\code{abstract}}{}

\item{\code{purpose}}{}

\item{\code{credit}}{}

\item{\code{status}}{}

\item{\code{pointOfContact}}{}

\item{\code{resourceMaintenance}}{}

\item{\code{graphicOverview}}{}

\item{\code{descriptiveKeywords}}{}

\item{\code{resourceConstraints}}{}

\item{\code{resourceFormat}}{}
}}
\section{Methods}{

\describe{
 \item{\code{new(xml, element, namespace, defaults)}}{
   This method is used to instantiate an ISOIdentification
 }
 \item{\code{setCitation(citation)}}{
   Sets an object of class \code{ISOCitation}
 }
 \item{\code{setAbstract(abstract)}}{
   Sets an abstract (object of class "character")
 }
 \item{\code{setPurpose(purpose)}}{
   Sets a purpose (object of class "character")
 }
 \item{\code{addCredit(credit)}}{
   Adds a credit (object of class "character")
 }
 \item{\code{delCredit(credit)}}{
   Deletes a credit (object of class "character")
 }
 \item{\code{addStatus(status)}}{
   Adds a status, as object of class "character" or class \code{ISOStatus}. If
   an object of class "character" is specified, it must match the accepted
   progress status values \code{ISOStatus$values()}.
 }
 \item{\code{delStatus(status)}}{
   Deletes a status, as object of class "character" or class \code{ISOStatus}. If
   an object of class "character" is specified, it must match the accepted
   progress status values \code{ISOStatus$values()}.
 }
 \item{\code{addPointOfContact(pointOfContact)}}{
   Adds an object of class \code{ISOResponsibleParty}
 }
 \item{\code{delPointOfContact(pointOfContact)}}{
   Deletes an object of class \code{ISOResponsibleParty}
 }
 \item{\code{addResourceMaintenance(resourceMaintenance)}}{
   Adds a resource maintenance information as object of class
   \code{ISOMaintenanceInformation}.
 }
 \item{\code{setResourceMaintenance(resourceMaintenance)}}{
   Sets a resource maintenance information as object of class
   \code{ISOMaintenanceInformation}.
 }
 \item{\code{delResourceMaintenance(resourceMaintenance)}}{
   Deletes a resource maintenance information as object of class
   \code{ISOMaintenanceInformation}.
 }
 \item{\code{addGraphicOverview(graphicOverview)}}{
   Adds an object of class \code{ISOBrowseGraphic}
 }
 \item{\code{setGraphicOverview(graphicOverview)}}{
   Sets an object of class \code{ISOBrowseGraphic}
 }
 \item{\code{delGraphicOverview(graphicOverview)}}{
   Deletes an object of class \code{ISOBrowseGraphic}
 }
 \item{\code{addFormat(format)}}{
   Adds a resource format, object of class \code{ISOFormat}
 }
 \item{\code{delFormat(format)}}{
   Deletes a resource format, object of class \code{ISOFormat}
 }
 \item{\code{addKeywords(keywords)}}{
   Adds a set of keywords as object of class \code{ISOKeywords}
 }
 \item{\code{setKeywords(keywords)}}{
   Sets a set of keywords as object of class \code{ISOKeywords}
 }
 \item{\code{delKeywords(keywords)}}{
   Deletes a set of keywords as object of class \code{ISOKeywords}
 }
 \item{\code{addResourceConstraints(resourceConstraints)}}{
   Adds an object extending \code{ISOConstraints}, either an object of class
   \code{ISOLegalConstraints} or \code{ISOSecurityConstraints}
 }
 \item{\code{setResourceConstraints(resourceConstraints)}}{
   Sets an object extending \code{ISOConstraints}, either an object of class
   \code{ISOLegalConstraints} or \code{ISOSecurityConstraints}
 }
 \item{\code{delResourceConstraints(resourceConstraints)}}{
   Deletes an object extending \code{ISOConstraints}, either an object of class
   \code{ISOLegalConstraints} or \code{ISOSecurityConstraints}
 }
}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\keyword{ISO}
\keyword{identification}

