% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMLParameterValueGroup.R
\docType{class}
\name{GMLParameterValueGroup}
\alias{GMLParameterValueGroup}
\title{GMLParameterValueGroup}
\format{\code{\link{R6Class}} object.}
\usage{
GMLParameterValueGroup
}
\value{
Object of \code{\link{R6Class}} for modelling an GML parameter value group
}
\description{
GMLParameterValueGroup
}
\section{Fields}{

\describe{
\item{\code{group}}{}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml, defaults)}}{
   This method is used to instantiate a GML ParameterValue
 }
 \item{\code{addParameterValue(parameterValue)}}{
   Adds a parameter value, object of class 'GMLParameterValue'
 }
 \item{\code{delParameterValue(parameterValue)}}{
   Deletes a parameter value, object of class 'GMLParameterValue'
 }
 \item{\code{setOperationParameterGroup(operationParameterGroup)}}{
   Sets the operation parameter group, object of class \code{GMLOperationParameterGroup}
 }
}
}

\examples{
  gml <- GMLParameterValueGroup$new()

}
\references{
ISO 19136:2007 Geographic Information -- Geographic Markup Language.
  http://www.iso.org/iso/iso_catalogue/catalogue_tc/catalogue_detail.htm?csnumber=32554 
  
  OGC Geography Markup Language. http://www.opengeospatial.org/standards/gml
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{GML}
\keyword{ISO}
\keyword{group}
\keyword{parameter}
\keyword{value}
