% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOVerticalExtent.R
\docType{class}
\name{ISOVerticalExtent}
\alias{ISOVerticalExtent}
\title{ISOVerticalExtent}
\format{\code{\link{R6Class}} object.}
\usage{
ISOVerticalExtent
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO VerticalExtent
}
\description{
ISOVerticalExtent
}
\section{Fields}{

\describe{
\item{\code{minimalValue}}{[\code{\link{numeric}}] the minimum value for the vertical extent}

\item{\code{maximalValue}}{[\code{\link{numeric}}] the maximum value for the vertical extent}

\item{\code{unitOfMeasure}}{[\code{\link{character}}] the unit of measure}

\item{\code{verticalCRS}}{[\code{\link{GMLVerticalCRS}}] the vertical CRS}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOVerticalExtent}}
 }
 \item{\code{setMinimumValue(minimumValue)}}{
   Sets the minimum value, object of class \code{\link{numeric}}
 }
 \item{\code{setMaximumValue(maximumValue)}}{
   Sets the maximum value, object of class \code{\link{numeric}}
 }
 \item{\code{setUnitOfMeasure(uom)}}{
   Sets the unit of measure, object of class \code{\link{character}}
 }
 \item{\code{setVerticalCRS(verticalCRS)}}{
   Sets the vertical CRS, object of class \code{\link{GMLVerticalCRS}}
 }
}
}

\examples{
  ve <- ISOVerticalExtent$new()
  ve$setMinimumValue(0)
  ve$setMaximumValue(19)
  xml <- ve$encode()
  
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{extent}
\keyword{vertical}
