% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOBrowseGraphic.R
\docType{class}
\name{ISOBrowseGraphic}
\alias{ISOBrowseGraphic}
\title{ISOBrowseGraphic}
\format{\code{\link{R6Class}} object.}
\usage{
ISOBrowseGraphic
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO BrowseGraphic
}
\description{
ISOBrowseGraphic
}
\section{Fields}{

\describe{
\item{\code{fileName}}{[\code{\link{character}}] file name}

\item{\code{fileDescription}}{[\code{\link{character}}] file description}

\item{\code{fileType}}{[\code{\link{character}}] file type}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml, fileName, fileDescription, fileType)}}{
   This method is used to instantiate an \code{\link{ISOBrowseGraphic}}
 }
 \item{\code{setFileName(fileName, locales)}}{
   Set file name. Locale names can be specified 
   as \code{list} with the \code{locales} argument.
 }
 \item{\code{setFileDescription(fileDescription, locales)}}{
   Set file description. Locale names can be specified 
   as \code{list} with the \code{locales} argument.
 }
 \item{\code{setFileType(fileType, locales)}}{
   Set file type. Locale names can be specified 
   as \code{list} with the \code{locales} argument.
 }
}
}

\examples{
 md <- ISOBrowseGraphic$new(
  fileName = "http://wwww.somefile.org/png",
  fileDescription = "Map Overview",
  fileType = "image/png"
 )
 xml <- md$encode()

}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{browse}
\keyword{graphic}
