% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryInstrument.R
\docType{class}
\name{ISOImageryInstrument}
\alias{ISOImageryInstrument}
\title{ISOImageryPlatform}
\format{\code{\link{R6Class}} object.}
\usage{
ISOImageryInstrument
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO imagery platform
}
\description{
ISOImageryPlatform
}
\section{Fields}{

\describe{
\item{\code{citation}}{[\code{list} of \code{\link{ISOCitation}}]}

\item{\code{identifier}}{[\code{\link{ISOMetaIdentifier}}]}

\item{\code{type}}{[\code{\link{character}}|\code{\link{ISOLocalisedCharacterString}}]}

\item{\code{description}}{[\code{\link{character}}|\code{\link{ISOLocalisedCharacterString}}]}

\item{\code{mountedOn}}{[\code{list} of \code{\link{ISOImageryPlatform}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOImageryPlatform}}
 }
 \item{\code{addCitation(citation)}}{
   Adds citation, object of class \code{\link{ISOCitation}}
 }
 \item{\code{delCitation(citation)}}{
   Deletes a citation, object of class \code{\link{ISOCitation}}
 }
 \item{\code{setIdentifier(identifier)}}{
   Sets an identifier, object of class \code{character} or \code{\link{ISOMetaIdentifier}}
 }
 \item{\code{setType(type, locales)}}{
   Sets a type (object of class "character"). Locale names can be 
   specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{setDescription(description, locales)}}{
   Sets a description (object of class "character"). Locale names can be 
   specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{addPlatform(platform)}}{
   Add a platform, object of class \code{\link{ISOImageryPlatform}}
 }
 \item{\code{delPlatform(platform)}}{
   Deletes a platform, object of class \code{\link{ISOImageryPlatform}}
 }
}
}

\examples{
   md <- ISOImageryInstrument$new()
   md$setIdentifier("identifier")
   md$setType("type")
   md$setDescription("description")
   xml <- md$encode()

}
\references{
ISO 19115-2:2009 - Geographic information -- Metadata Part 2: Extensions for imagery and gridded data
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{imagery}
\keyword{platform}
