% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOImageryObjective.R
\docType{class}
\name{ISOImageryObjective}
\alias{ISOImageryObjective}
\title{ISOImageryObjective}
\format{\code{\link{R6Class}} object.}
\usage{
ISOImageryObjective
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO imagery objective
}
\description{
ISOImageryObjective
}
\section{Fields}{

\describe{
\item{\code{identifier}}{[\code{\link{ISOMetaIdentifier}}]}

\item{\code{priority}}{[\code{\link{character}}|\code{\link{ISOLocalisedCharacterString}}]}

\item{\code{type}}{[\code{list} of \code{\link{ISOImageryObjectiveType}}]}

\item{\code{function}}{[\code{list} of \code{\link{character}}|\code{\link{ISOLocalisedCharacterString}}]}

\item{\code{extent}}{[\code{list} of \code{\link{ISOExtent}}]}

\item{\code{sensingInstrument}}{[\code{list} of \code{\link{ISOImageryInstrument}}]}

\item{\code{pass}}{[\code{list} of \code{\link{ISOImageryPlatformPass}}]}

\item{\code{objectiveOccurance}}{[\code{list} of \code{\link{ISOImageryEvent}}]}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOImageryObjective}}
 }
 \item{\code{setIdentifier(identifier)}}{
   Sets an identifier, object of class \code{character} or \code{\link{ISOMetaIdentifier}}
 }
 \item{\code{setPriority(priority, locales)}}{
   Sets a priority (object of class "character"). Locale names can be 
   specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{addType(type)}}{
   Add type, object of class \code{\link{ISOImageryObjectiveType}} or 'character' among values
   given by \code{ISOImageryObjectiveType$values()} or any free text.
 }
 \item{\code{delType(type)}}{
   Deletes type, object of class \code{\link{ISOImageryObjectiveType}} or 'character' among values
   given by \code{ISOImageryObjectiveType$values()} or any free text.
 }
 \item{\code{addFunction(fun, locales)}}{
   Adds a function (object of class "character"). Locale names can be 
   specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{delFunction(fun, locales)}}{
   Deletes a function (object of class "character"). Locale names can be 
   specified as \code{list} with the \code{locales} argument.
 }
 \item{\code{addExtent(extent)}}{
   Adds an extent, object of class \code{\link{ISOExtent}}
 }
 \item{\code{delExtent(extent)}}{
   Deletes an extent, object of class \code{\link{ISOExtent}}
 }
 \item{\code{addSensingInstrument(instrument)}}{
   Adds an instrument, object of class \code{\link{ISOImageryInstrument}}
 }
 \item{\code{delSensingInstrument(instrument)}}{
   Deletes an instrument, object of class \code{\link{ISOImageryInstrument}}
 }
 \item{\code{addPlatformPass(pass)}}{
   Adds an platform pass, object of class \code{\link{ISOImageryPlatformPass}}
 }
 \item{\code{delPlatformPass(pass)}}{
   Deletes an platform pass, object of class \code{\link{ISOImageryPlatformPass}}
 }
 \item{\code{addObjectiveOccurance(event)}}{
   Adds an objective occurance, object of class \code{\link{ISOImageryEvent}}
 }
 \item{\code{delObjectiveOccurance(event)}}{
   Deletes an objective occurance, object of class \code{\link{ISOImageryEvent}}
 }
}
}

\examples{
   #encoding
   md <- ISOImageryObjective$new()
   md$setIdentifier("identifier")
   md$setPriority("urgent")
   md$addType("survey")
   md$addFunction("my_function")
   evt <- ISOImageryEvent$new()
   evt$setIdentifier("event_1")
   evt$setTrigger("manual")
   evt$setContext("pass")
   evt$setSequence("instantaneous")
   evt$setTime(Sys.time())
   md$addObjectiveOccurance(evt)
   extent <- ISOExtent$new()
   bbox <- ISOGeographicBoundingBox$new(minx = -180, miny = -90, maxx = 180, maxy = 90)
   extent$setGeographicElement(bbox)
   time <- ISOTemporalExtent$new()
   start <- ISOdate(2000, 1, 12, 12, 59, 45)
   end <- ISOdate(2010, 8, 22, 13, 12, 43)
   tp <- GMLTimePeriod$new(beginPosition = start, endPosition = end)
   time$setTimePeriod(tp)
   extent$setTemporalElement(time)
   vert <- ISOVerticalExtent$new()
   vert$setMinimumValue(0)
   vert$setMaximumValue(19)
   extent$setVerticalElement(vert)
   md$addExtent(extent)
   md$sensingInstrument = NA
   md$pass = NA
   xml <- md$encode()

}
\references{
ISO 19115-2:2009 - Geographic information -- Metadata Part 2: Extensions for imagery and gridded data
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{imagery}
\keyword{objective}
