% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOMedium.R
\docType{class}
\name{ISOMedium}
\alias{ISOMedium}
\title{ISOMedium}
\format{\code{\link{R6Class}} object.}
\usage{
ISOMedium
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Citation
}
\description{
ISOMedium
}
\section{Fields}{

\describe{
\item{\code{name}}{[\code{\link{ISOMediumName}}|\code{\link{character}}] name}

\item{\code{density}}{[\code{\link{numeric}}] density}

\item{\code{densityUnits}}{\code{\link{character}} density unit}

\item{\code{volumes}}{[\code{\link{integer}}] volumes}

\item{\code{mediumFormat}}{[\code{\link{ISOMediumFormat}}|\code{\link{character}}] format}

\item{\code{mediumNode}}{\code{\link{character}} note}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOMedium}}
 }
 \item{\code{setName(name)}}{
   Set the medium name, object of class 'character' or \code{\link{ISOMediumName}}
 }
 \item{\code{addDensity(density)}}{
   Adds a density
 }
 \item{\code{delDensity(density)}}{
   Deletes density
 }
 \item{\code{setDensityUnits(densityUnits)}}{
   Set density unit
 }
 \item{\code{setVolumes(volumes)}}{
   Set volumes
 }
 \item{\code{addMediumFormat(mediumFormat)}}{
   Adds a medium format, object of class 'character' or \code{\link{ISOMediumFormat}}
 }
 \item{\code{delMediumFormat(mediumFormat)}}{
   Deletes a medium format, object of class 'character' or \code{\link{ISOMediumFormat}}
 }
 \item{\code{setMediumNote(mediumNote, locales)}}{
   Set a medium note. Locale names can be specified as \code{list} with 
   the \code{locales} argument.
 }
}
}

\examples{
 md <- ISOMedium$new()
 md$setName("satellite")
 md$addDensity(1.0)
 md$setDensityUnits("string")
 md$setVolumes(1L)
 md$addMediumFormat("tar")
 md$setMediumNote("some note")
 xml <- md$encode()
 
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{medium}
