% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOParameter.R
\docType{class}
\name{ISOParameter}
\alias{ISOParameter}
\title{ISOParameter}
\format{\code{\link{R6Class}} object.}
\usage{
ISOParameter
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOParameter
}
\description{
ISOParameter
}
\section{Fields}{

\describe{
\item{\code{name}}{[\code{\link{character}}] name}

\item{\code{direction}}{[\code{\link{ISOParameterDirection}}] direction}

\item{\code{description}}{[\code{\link{character}}] description}

\item{\code{optionality}}{[\code{\link{logical}}] parameter optionality}

\item{\code{repeatability}}{[\code{\link{logical}}] parameter repeatability}

\item{\code{valueType}}{[\code{\link{ISOTypeName}}|\code{\link{character}}] value type}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOParameter}}
 }
 \item{\code{setName(name, attributeType, locales)}}{
   Sets the parameter name (\code{character}) and attributeType (\code{\link{ISOTypeName}}
   or \code{character}). Locale names can be specified as \code{list} with the 
   \code{locales} argument.
 }
 \item{\code{setDirection(direction)}}{
   Sets the direction, an object of class \code{\link{ISOParameterDirection}} or any
   \code{character} value among \code{ISOParameterDirection$values()}
 }
 \item{\code{setDescription(description, locales)}}{
   Sets the parameter description. Locale names can be specified as 
   \code{list} with the \code{locales} argument.
 }
 \item{\code{setOptionality(optional)}}{
   Set whether the parameter is optional (\code{TRUE}), \code{FALSE} otherwise
 }
 \item{\code{setRepeatability(repeatable)}}{
   Set whether the parameter is repeatable (\code{TRUE}), \code{FALSE} otherwise
 }
 \item{\code{setValueType(valueType, locales)}}{
   Sets the type of parameter value, object of class \code{\link{ISOTypeName}} or \code{character}
   Locale names can be specified as \code{list} with the \code{locales} argument.
 }
}
}

\examples{
  md <- ISOParameter$new()
  md$setName("name", "attType")
  md$setDirection("in")
  md$setDescription("description")
  md$setOptionality(FALSE)
  md$setRepeatability(FALSE)
  md$setValueType("CharacterString")  
  xml <- md$encode()

}
\references{
ISO 19119:2005 - Geographic information -- Services
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{parameter}
