% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISODataSet.R
\docType{class}
\name{ISODataSet}
\alias{ISODataSet}
\title{ISODataSet}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISODataSet
}
\description{
ISODataSet
}
\section{Fields}{

\describe{
\item{\code{has}}{[\code{\link{ISOMetadata}}] associated metadata}

\item{\code{partOf}}{[\code{\link{ISOAbstractAggregate}}] part of other aggregate(s)}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISODataSet}}
 }
 \item{\code{addHas(metadata)}}{
   Adds a metadata, object of class \\code{\link{ISOMetadata}}
 }
 \item{\code{delHas(metadata)}}{
   Deletes a metadata, object of class \code{\link{ISOMetadata}}
 }
 \item{\code{addPartOf(partOf)}}{
   Adds a partOf element, object that inherits from \code{\link{ISOAbstractAggregate}}
 }
 \item{\code{delPartOf(partOf)}}{
   Deletes a partOf element, object that inherits from \code{\link{ISOAbstractAggregate}}
 }
}
}

\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{dataset}
